/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.net.StatSyncMessage;
import enginecrafter77.survivalinc.stats.StatTracker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class StatCapability
implements ICapabilitySerializable<NBTBase> {
    private static ResourceLocation identificator = new ResourceLocation("survivalinc", "stats");
    @CapabilityInject(value=StatTracker.class)
    public static final Capability<StatTracker> target = null;
    private final StatTracker tracker = (StatTracker)target.getDefaultInstance();

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == target;
    }

    public <TARGET> TARGET getCapability(Capability<TARGET> capability, EnumFacing facing) {
        return (TARGET)(this.hasCapability(capability, facing) ? target.cast((Object)this.tracker) : null);
    }

    public NBTBase serializeNBT() {
        return target.getStorage().writeNBT(target, (Object)this.tracker, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        target.getStorage().readNBT(target, (Object)this.tracker, null, nbt);
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(identificator, (ICapabilityProvider)new StatCapability());
    }

    @SubscribeEvent
    public static void refreshClientData(PlayerEvent event) {
        if ((event instanceof PlayerEvent.PlayerLoggedInEvent || event instanceof PlayerEvent.PlayerChangedDimensionEvent) && !event.player.field_70170_p.field_72995_K) {
            SurvivalInc.logger.info("Sending stat tracker data to {}", (Object)event.player.func_70005_c_());
            SurvivalInc.proxy.net.sendTo((IMessage)new StatSyncMessage(event.player.field_70170_p), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        StatTracker stat = (StatTracker)event.player.getCapability(target, null);
        stat.update(event.player);
        if (event.side == Side.SERVER && event.player.field_70170_p.func_72820_D() % (long)ModConfig.GENERAL.serverSyncDelay == 0L) {
            SurvivalInc.proxy.net.sendToAll((IMessage)new StatSyncMessage(event.player));
        }
    }
}

