/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.net.StatSyncMessage;
import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatProvider;
import enginecrafter77.survivalinc.stats.StatTracker;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StatCommand
extends CommandBase {
    private final Style statNameStyle = new Style().func_150238_a(TextFormatting.GREEN);

    public String func_71517_b() {
        return "stat";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/stat <player> [list|<get|set> [stat] [value]]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new CommandException("Insufficient Arguments\nUsage: " + this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
        if (args.length < 2 || args[1].equals("list")) {
            TextComponentString component = new TextComponentString(player.getDisplayNameString() + "'s stats:");
            for (StatProvider<?> provider : tracker.getRegisteredProviders()) {
                component.func_150258_a("\n ");
                component.func_150257_a(new TextComponentTranslation(String.format("stat.%s.name", provider.getStatID().toString()), new Object[0]).func_150255_a(this.statNameStyle));
                component.func_150258_a("(" + TextFormatting.YELLOW + provider.getStatID().toString() + TextFormatting.RESET + ")");
                component.func_150258_a(": " + tracker.getRecord(provider).toString());
            }
            sender.func_145747_a((ITextComponent)component);
            return;
        } else {
            if (args.length < 3) {
                throw new CommandException("Insufficient Arguments\nUsage: " + this.func_71518_a(sender), new Object[0]);
            }
            ResourceLocation res = new ResourceLocation(args[2]);
            StatProvider<?> provider = tracker.getProvider(res);
            if (provider == null) {
                throw new CommandException("Stat " + res.toString() + " does not exist!", new Object[0]);
            }
            Object record = tracker.getRecord(provider);
            if (args[1].equals("set")) {
                if (!(record instanceof SimpleStatRecord)) throw new CommandException("Stat " + provider.getStatID().toString() + " uses non-standard record type!", new Object[0]);
                if (args.length < 4) {
                    throw new CommandException("Insufficient Arguments\nUsage: " + this.func_71518_a(sender), new Object[0]);
                }
                ((SimpleStatRecord)record).setValue(Float.parseFloat(args[3]));
                SurvivalInc.proxy.net.sendToAll((IMessage)new StatSyncMessage((EntityPlayer)player));
                return;
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(provider.getStatID() + ": " + record.toString()));
            }
        }
    }
}

