/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats.effect;

import enginecrafter77.survivalinc.stats.StatRecord;
import enginecrafter77.survivalinc.stats.effect.EffectFilter;
import enginecrafter77.survivalinc.stats.effect.StatEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;

public class EffectApplicator<RECORD extends StatRecord>
implements StatEffect<RECORD> {
    public final Collection<EffectFilterContainer> registry = new LinkedList<EffectFilterContainer>();

    protected EffectFilterContainer createNewContainer(StatEffect<? super RECORD> effect) {
        return new EffectFilterContainer(effect);
    }

    public EffectFilterContainer add(StatEffect<? super RECORD> effect) {
        EffectFilterContainer container = this.createNewContainer(effect);
        this.registry.add(container);
        return container;
    }

    @Override
    public void apply(RECORD record, EntityPlayer player) {
        for (EffectFilterContainer container : this.registry) {
            container.checkAndApply(record, player);
        }
    }

    public class EffectFilterContainer {
        public final StatEffect<? super RECORD> effect;
        public final Collection<EffectFilter<? super RECORD>> filters;

        public EffectFilterContainer(StatEffect<? super RECORD> effect) {
            this.effect = effect;
            this.filters = new ArrayList(1);
        }

        public EffectFilterContainer addFilter(EffectFilter<? super RECORD> filter) {
            this.filters.add(filter);
            return this;
        }

        protected void checkAndApply(RECORD record, EntityPlayer player) {
            for (EffectFilter test : this.filters) {
                if (test.isApplicableFor(record, player)) continue;
                return;
            }
            this.effect.apply(record, player);
        }
    }
}

