/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats.effect;

import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import enginecrafter77.survivalinc.stats.effect.CalculatorFunction;
import enginecrafter77.survivalinc.stats.effect.StatEffect;
import java.util.function.BiFunction;
import net.minecraft.entity.player.EntityPlayer;

public class ValueStatEffect
implements CalculatorFunction,
StatEffect<SimpleStatRecord> {
    public final Operation operation;
    public final float argument;

    public ValueStatEffect(Operation operation, float argument) {
        this.operation = operation;
        this.argument = argument;
    }

    @Override
    public void apply(SimpleStatRecord record, EntityPlayer player) {
        float value = record.getValue();
        value = this.operation.function.apply(Float.valueOf(value), Float.valueOf(this.argument)).floatValue();
        record.setValue(value);
    }

    @Override
    public float apply(EntityPlayer player, float current) {
        return this.operation.function.apply(Float.valueOf(current), Float.valueOf(this.argument)).floatValue();
    }

    public static enum Operation {
        OFFSET((current, mod) -> Float.valueOf(current.floatValue() + mod.floatValue())),
        SCALE((current, mod) -> Float.valueOf(current.floatValue() * mod.floatValue())),
        POWER((current, mod) -> Float.valueOf((float)Math.pow(current.floatValue(), mod.floatValue())));

        public final BiFunction<Float, Float, Float> function;

        private Operation(BiFunction<Float, Float, Float> function) {
            this.function = function;
        }
    }
}

