/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats.impl;

import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.stats.effect.CalculatorFunction;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class ArmorModifier
implements CalculatorFunction {
    protected static final int armorPieces = 4;
    protected Map<ItemArmor.ArmorMaterial, Float[]> materialmap = new HashMap<ItemArmor.ArmorMaterial, Float[]>();
    protected final float[] conductivityDistribution;

    public ArmorModifier(float[] conductivityDistribution) {
        this.conductivityDistribution = conductivityDistribution;
    }

    public ArmorModifier() {
        int index;
        float sum = 0.0f;
        this.conductivityDistribution = new float[4];
        for (index = 0; index < 4; ++index) {
            this.conductivityDistribution[index] = (float)ModConfig.HEAT.distributionVector[index];
            sum += this.conductivityDistribution[index];
        }
        if (sum != 1.0f) {
            index = 0;
            while (index < 4) {
                int n = index++;
                this.conductivityDistribution[n] = this.conductivityDistribution[n] / sum;
            }
        }
    }

    public void addArmorType(ItemArmor.ArmorMaterial material, float conductivity) {
        Float[] conductivityVectorInstance = new Float[4];
        for (int index = 0; index < 4; ++index) {
            conductivityVectorInstance[index] = Float.valueOf((float)Math.pow(conductivity, this.conductivityDistribution[index]));
        }
        this.materialmap.put(material, conductivityVectorInstance);
    }

    @Override
    public float apply(EntityPlayer target, float current) {
        float buff = 1.0f;
        int index = 0;
        for (ItemStack stack : target.func_184193_aE()) {
            ItemArmor.ArmorMaterial material;
            if (stack.func_77973_b() instanceof ItemArmor && this.materialmap.containsKey(material = ((ItemArmor)stack.func_77973_b()).func_82812_d())) {
                buff *= this.materialmap.get(material)[index].floatValue();
            }
            ++index;
        }
        return current * buff;
    }
}

