/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats.impl;

import com.google.common.collect.Range;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatProvider;
import enginecrafter77.survivalinc.stats.StatRecord;
import enginecrafter77.survivalinc.stats.StatRegisterEvent;
import enginecrafter77.survivalinc.stats.StatTracker;
import enginecrafter77.survivalinc.stats.effect.DamageStatEffect;
import enginecrafter77.survivalinc.stats.effect.EffectApplicator;
import enginecrafter77.survivalinc.stats.effect.FunctionalCalculator;
import enginecrafter77.survivalinc.stats.effect.FunctionalEffectFilter;
import enginecrafter77.survivalinc.stats.effect.PotionStatEffect;
import enginecrafter77.survivalinc.stats.impl.ArmorModifier;
import enginecrafter77.survivalinc.stats.impl.WetnessModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HeatModifier
implements StatProvider<SimpleStatRecord> {
    private static final long serialVersionUID = 6260092840749029918L;
    public static final DamageSource HYPERTHERMIA = new DamageSource("survivalinc_hyperthermia").func_151518_m().func_76348_h();
    public static final DamageSource HYPOTHERMIA = new DamageSource("survivalinc_hypothermia").func_151518_m().func_76348_h();
    public static final HeatModifier instance = new HeatModifier();
    public final Map<Block, Float> blockHeatMap;
    public final ArmorModifier armorInsulation;
    public final FunctionalCalculator targettemp = new FunctionalCalculator();
    public final FunctionalCalculator exchangerate = new FunctionalCalculator();
    public final EffectApplicator<SimpleStatRecord> consequences = new EffectApplicator();

    public HeatModifier() {
        this.blockHeatMap = new HashMap<Block, Float>();
        this.armorInsulation = new ArmorModifier();
    }

    public void init() {
        Float value;
        Block target;
        int separator;
        MinecraftForge.EVENT_BUS.register(HeatModifier.class);
        this.targettemp.add(HeatModifier::whenNearHotBlock);
        if (ModConfig.WETNESS.enabled) {
            this.exchangerate.add(HeatModifier::applyWetnessCooldown);
        }
        this.exchangerate.add(this.armorInsulation);
        this.consequences.add(new DamageStatEffect(HYPOTHERMIA, (float)ModConfig.HEAT.damageAmount, 10)).addFilter(FunctionalEffectFilter.byValue((Predicate<Float>)Range.lessThan((Comparable)Float.valueOf(10.0f))));
        this.consequences.add(new PotionStatEffect(MobEffects.field_76419_f, 0)).addFilter(FunctionalEffectFilter.byValue((Predicate<Float>)Range.lessThan((Comparable)Float.valueOf(20.0f))));
        this.consequences.add(new PotionStatEffect(MobEffects.field_76437_t, 0)).addFilter(FunctionalEffectFilter.byValue((Predicate<Float>)Range.lessThan((Comparable)Float.valueOf(25.0f))));
        this.consequences.add(HeatModifier::onHighTemperature).addFilter(FunctionalEffectFilter.byValue((Predicate<Float>)Range.greaterThan((Comparable)Float.valueOf(110.0f))));
        for (String entry : ModConfig.HEAT.blockHeatMap) {
            separator = entry.lastIndexOf(32);
            target = Block.func_149684_b((String)entry.substring(0, separator));
            value = Float.valueOf(Float.parseFloat(entry.substring(separator + 1)));
            this.blockHeatMap.put(target, value);
        }
        for (String entry : ModConfig.HEAT.armorMaterialConductivity) {
            separator = entry.lastIndexOf(32);
            target = ItemArmor.ArmorMaterial.valueOf((String)entry.substring(0, separator).toUpperCase());
            value = Float.valueOf(Float.parseFloat(entry.substring(separator + 1)));
            this.armorInsulation.addArmorType((ItemArmor.ArmorMaterial)target, value.floatValue());
        }
    }

    @SubscribeEvent
    public static void registerStat(StatRegisterEvent event) {
        event.register(instance);
    }

    @Override
    public void update(EntityPlayer player, StatRecord record) {
        float target;
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        if (player.field_70163_u < (double)player.field_70170_p.func_181545_F()) {
            target = (float)ModConfig.HEAT.caveTemperature;
        } else {
            Biome biome = player.field_70170_p.func_180494_b(player.func_180425_c());
            target = biome.func_180626_a(player.func_180425_c());
            if (target < -0.2f) {
                target = -0.2f;
            }
            if (target > 1.5f) {
                target = 1.5f;
            }
        }
        target = this.targettemp.apply(player, target * (float)ModConfig.HEAT.tempCoefficient);
        SimpleStatRecord heat = (SimpleStatRecord)record;
        float difference = Math.abs(target - heat.getValue());
        float rate = difference * (float)ModConfig.HEAT.heatExchangeFactor;
        rate = this.exchangerate.apply(player, rate);
        this.consequences.apply(heat, player);
        if (heat.getValue() > target) {
            rate *= -1.0f;
        }
        heat.addToValue(rate);
        heat.checkoutValueChange();
    }

    @Override
    public ResourceLocation getStatID() {
        return new ResourceLocation("survivalinc", "heat");
    }

    @Override
    public SimpleStatRecord createNewRecord() {
        SimpleStatRecord record = new SimpleStatRecord();
        record.setValueRange((Range<Float>)Range.closed((Comparable)Float.valueOf(-20.0f), (Comparable)Float.valueOf(120.0f)));
        record.setValue(80.0f);
        return record;
    }

    @Override
    public Class<SimpleStatRecord> getRecordClass() {
        return SimpleStatRecord.class;
    }

    public static void onHighTemperature(StatRecord record, EntityPlayer player) {
        if (ModConfig.HEAT.fireDuration > 0) {
            player.func_70015_d(1);
        } else {
            player.func_70097_a(HYPERTHERMIA, (float)ModConfig.HEAT.damageAmount);
        }
    }

    public static float applyWetnessCooldown(EntityPlayer player, float current) {
        StatTracker stats = (StatTracker)player.getCapability(StatCapability.target, null);
        SimpleStatRecord wetness = stats.getRecord(WetnessModifier.instance);
        return current * (1.0f + (float)ModConfig.HEAT.wetnessExchangeMultiplier * wetness.getNormalizedValue());
    }

    public static float whenNearHotBlock(EntityPlayer player, float current) {
        Vec3i offset = new Vec3i(ModConfig.HEAT.blockScanRange, 1.0, ModConfig.HEAT.blockScanRange);
        BlockPos originblock = player.func_180425_c();
        Iterable blocks = BlockPos.func_177980_a((BlockPos)originblock.func_177973_b(offset), (BlockPos)originblock.func_177971_a(offset));
        float heat = 0.0f;
        for (BlockPos position : blocks) {
            Block block = player.field_70170_p.func_180495_p(position).func_177230_c();
            if (!HeatModifier.instance.blockHeatMap.containsKey(block)) continue;
            float currentheat = HeatModifier.instance.blockHeatMap.get(block).floatValue();
            float proximity = (float)Math.sqrt(player.func_174791_d().func_72436_e(new Vec3d((Vec3i)position)));
            if (!((currentheat *= (float)(ModConfig.HEAT.gaussScaling / (Math.pow(proximity, 2.0) + ModConfig.HEAT.gaussScaling))) > heat)) continue;
            heat = currentheat;
        }
        return current + heat;
    }
}

