/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats.impl;

import com.google.common.collect.Range;
import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.net.WaterDrinkMessage;
import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatProvider;
import enginecrafter77.survivalinc.stats.StatRecord;
import enginecrafter77.survivalinc.stats.StatRegisterEvent;
import enginecrafter77.survivalinc.stats.StatTracker;
import enginecrafter77.survivalinc.stats.effect.DamageStatEffect;
import enginecrafter77.survivalinc.stats.effect.EffectApplicator;
import enginecrafter77.survivalinc.stats.effect.FunctionalEffectFilter;
import enginecrafter77.survivalinc.stats.effect.PotionStatEffect;
import enginecrafter77.survivalinc.stats.effect.ValueStatEffect;
import java.util.function.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class HydrationModifier
implements IMessageHandler<WaterDrinkMessage, IMessage>,
StatProvider<SimpleStatRecord> {
    private static final long serialVersionUID = 6252973395407389818L;
    public static final FunctionalEffectFilter<Object> isOutsideOverworld = FunctionalEffectFilter.byPlayer(player -> player.field_71093_bK != 0);
    public static final DamageSource DEHYDRATION = new DamageSource("survivalinc_dehydration").func_151518_m().func_76348_h();
    public static final HydrationModifier instance = new HydrationModifier();
    public final EffectApplicator<SimpleStatRecord> effects = new EffectApplicator();

    public void init() {
        MinecraftForge.EVENT_BUS.register(HydrationModifier.class);
        FunctionalEffectFilter<SimpleStatRecord> nasfat = FunctionalEffectFilter.byValue((Predicate<Float>)Range.lessThan((Comparable)Float.valueOf(15.0f)));
        this.effects.add(new ValueStatEffect(ValueStatEffect.Operation.OFFSET, -0.006f)).addFilter(isOutsideOverworld);
        this.effects.add(new ValueStatEffect(ValueStatEffect.Operation.OFFSET, -0.5f)).addFilter(FunctionalEffectFilter.byPlayer(Entity::func_180799_ab));
        this.effects.add(new DamageStatEffect(DEHYDRATION, 4.0f, 0)).addFilter(FunctionalEffectFilter.byValue((Predicate<Float>)Range.lessThan((Comparable)Float.valueOf(5.0f))));
        this.effects.add(new PotionStatEffect(MobEffects.field_76421_d, 5)).addFilter(FunctionalEffectFilter.byValue((Predicate<Float>)Range.lessThan((Comparable)Float.valueOf(40.0f))));
        this.effects.add(new PotionStatEffect(MobEffects.field_76437_t, 5)).addFilter(FunctionalEffectFilter.byValue((Predicate<Float>)Range.lessThan((Comparable)Float.valueOf(40.0f))));
        this.effects.add(new PotionStatEffect(MobEffects.field_76419_f, 5)).addFilter(nasfat);
        this.effects.add(new PotionStatEffect(MobEffects.field_76431_k, 5)).addFilter(nasfat);
        this.effects.add(HydrationModifier::naturalDrain);
    }

    @Override
    public void update(EntityPlayer target, StatRecord record) {
        SimpleStatRecord hydration = (SimpleStatRecord)record;
        this.effects.apply(hydration, target);
        hydration.checkoutValueChange();
    }

    @Override
    public ResourceLocation getStatID() {
        return new ResourceLocation("survivalinc", "hydration");
    }

    @Override
    public SimpleStatRecord createNewRecord() {
        SimpleStatRecord record = new SimpleStatRecord();
        record.setValueRange((Range<Float>)Range.closed((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(100.0f)));
        record.setValue((float)ModConfig.HYDRATION.startValue);
        return record;
    }

    @Override
    public Class<SimpleStatRecord> getRecordClass() {
        return SimpleStatRecord.class;
    }

    public IMessage onMessage(WaterDrinkMessage message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer world = player.func_71121_q();
        RayTraceResult water_rt = HydrationModifier.raytraceWaterDrinking((EntityPlayer)player, message.getHand());
        if (water_rt != null) {
            SurvivalInc.logger.info("Player drink request authorized.");
            StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
            SimpleStatRecord hydration = tracker.getRecord(instance);
            hydration.addToValue((float)ModConfig.HYDRATION.sipVolume);
            HydrationModifier.spawnWaterDrinkParticles(world, water_rt.field_72307_f);
        } else {
            SurvivalInc.logger.warn("Player {}'s client issued a fake WaterDrinkMessage.");
        }
        return null;
    }

    public static void naturalDrain(SimpleStatRecord record, EntityPlayer player) {
        StatTracker tracker;
        SimpleStatRecord heat;
        float drain = (float)ModConfig.HYDRATION.passiveDrain;
        if (ModConfig.HEAT.enabled && (double)(heat = (tracker = (StatTracker)player.getCapability(StatCapability.target, null)).getRecord(instance)).getNormalizedValue() > ModConfig.HYDRATION.sweatingThreshold) {
            drain = (float)((double)drain * ModConfig.HYDRATION.sweatingMultiplier);
        }
        record.addToValue(-drain);
    }

    @SubscribeEvent
    public static void registerStat(StatRegisterEvent event) {
        event.register(instance);
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        RayTraceResult water_rt = HydrationModifier.raytraceWaterDrinking(player, event.getHand());
        if (water_rt != null) {
            StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
            SimpleStatRecord hydration = tracker.getRecord(instance);
            hydration.addToValue((float)ModConfig.HYDRATION.sipVolume);
            SurvivalInc.proxy.net.sendToServer((IMessage)new WaterDrinkMessage(event.getHand()));
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        RayTraceResult water_rt = HydrationModifier.raytraceWaterDrinking(player, event.getHand());
        if (water_rt != null) {
            StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
            SimpleStatRecord hydration = tracker.getRecord(instance);
            hydration.addToValue((float)ModConfig.HYDRATION.sipVolume);
            if (!player.field_70170_p.field_72995_K) {
                HydrationModifier.spawnWaterDrinkParticles((WorldServer)player.field_70170_p, water_rt.field_72307_f);
            }
        }
    }

    @SubscribeEvent
    public static void onItemConsumed(LivingEntityUseItemEvent.Finish event) {
        StatTracker stats;
        PotionType potion;
        ItemStack stack = event.getItem();
        if (stack.func_77973_b() == Items.field_151068_bn && (potion = PotionUtils.func_185191_c((ItemStack)stack)) == PotionTypes.field_185230_b && (stats = (StatTracker)event.getEntityLiving().getCapability(StatCapability.target, null)) != null) {
            stats.getRecord(instance).addToValue((float)ModConfig.HYDRATION.sipVolume * 2.0f);
        }
    }

    private static RayTraceResult raytraceWaterDrinking(EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_190926_b()) {
            BlockPos position;
            Vec3d look = player.func_174824_e(1.0f).func_178787_e(player.func_70040_Z().func_72441_c(player.func_70040_Z().field_72450_a < 0.0 ? -0.5 : 0.5, -1.0, player.func_70040_Z().field_72449_c < 0.0 ? -0.5 : 0.5));
            RayTraceResult raytrace = player.field_70170_p.func_72901_a(player.func_174824_e(1.0f), look, true);
            if (raytrace != null && raytrace.field_72313_a == RayTraceResult.Type.BLOCK && player.field_70170_p.func_180495_p(position = raytrace.func_178782_a()).func_185904_a() == Material.field_151586_h) {
                return raytrace;
            }
        }
        return null;
    }

    private static void spawnWaterDrinkParticles(WorldServer world, Vec3d position) {
        world.func_175739_a(EnumParticleTypes.WATER_SPLASH, position.field_72450_a, position.field_72448_b + 0.1, position.field_72449_c, 20, 0.5, 0.1, 0.5, 0.1, null);
        world.func_175739_a(EnumParticleTypes.WATER_BUBBLE, position.field_72450_a, position.field_72448_b + 0.1, position.field_72449_c, 20, 0.5, 0.1, 0.5, 0.1, null);
        world.func_184133_a(null, new BlockPos(position), SoundEvents.field_187549_bG, SoundCategory.AMBIENT, 0.5f, 1.5f);
    }
}

