/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats.impl;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.net.StatSyncMessage;
import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatProvider;
import enginecrafter77.survivalinc.stats.StatRecord;
import enginecrafter77.survivalinc.stats.StatRegisterEvent;
import enginecrafter77.survivalinc.stats.StatTracker;
import enginecrafter77.survivalinc.stats.effect.EffectApplicator;
import enginecrafter77.survivalinc.stats.effect.FunctionalEffectFilter;
import enginecrafter77.survivalinc.stats.effect.SideEffectFilter;
import enginecrafter77.survivalinc.stats.effect.ValueStatEffect;
import enginecrafter77.survivalinc.stats.impl.HydrationModifier;
import enginecrafter77.survivalinc.stats.impl.SanityRecord;
import enginecrafter77.survivalinc.stats.impl.WetnessModifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SanityModifier
implements StatProvider<SanityRecord> {
    private static final long serialVersionUID = 6707924203617912749L;
    public static final ResourceLocation distortshader = new ResourceLocation("survivalinc", "shaders/distort.json");
    public static final SoundEvent staticbuzz = new SoundEvent(new ResourceLocation("survivalinc", "staticbuzz"));
    public static final SanityModifier instance = new SanityModifier();
    public final EffectApplicator<SanityRecord> effects = new EffectApplicator();
    public final Map<Item, Float> foodSanityMap = new HashMap<Item, Float>();

    public void init() {
        MinecraftForge.EVENT_BUS.register(SanityModifier.class);
        if (ModConfig.WETNESS.enabled) {
            this.effects.add(SanityModifier::whenWet).addFilter(FunctionalEffectFilter.byPlayer(Entity::func_70090_H).invert());
        }
        this.effects.add(new ValueStatEffect(ValueStatEffect.Operation.OFFSET, 0.004f)).addFilter(FunctionalEffectFilter.byPlayer(EntityPlayer::func_70608_bn));
        this.effects.add(SanityModifier::whenInDark).addFilter(HydrationModifier.isOutsideOverworld.invert());
        this.effects.add(SanityModifier::playStaticNoise).addFilter(SideEffectFilter.CLIENT);
        this.effects.add(SanityModifier::whenNearEntities);
        this.effects.add(SanityModifier::sleepDeprivation);
        for (String entry : ModConfig.SANITY.foodSanityMap) {
            int separator = entry.lastIndexOf(32);
            Item target = Item.func_111206_d((String)entry.substring(0, separator));
            Float value = Float.valueOf(Float.parseFloat(entry.substring(separator + 1)));
            this.foodSanityMap.put(target, value);
        }
    }

    @Override
    public void update(EntityPlayer target, StatRecord record) {
        if (target.func_184812_l_() || target.func_175149_v()) {
            return;
        }
        SanityRecord sanity = (SanityRecord)record;
        ++sanity.ticksAwake;
        this.effects.apply(sanity, target);
        sanity.checkoutValueChange();
    }

    @Override
    public ResourceLocation getStatID() {
        return new ResourceLocation("survivalinc", "sanity");
    }

    @Override
    public SanityRecord createNewRecord() {
        return new SanityRecord();
    }

    @Override
    public Class<SanityRecord> getRecordClass() {
        return SanityRecord.class;
    }

    @SubscribeEvent
    public static void registerStat(StatRegisterEvent event) {
        event.register(instance);
    }

    public static void sleepDeprivation(SanityRecord record, EntityPlayer player) {
        if (record.getTicksAwake() > ModConfig.SANITY.sleepDeprivationMin) {
            record.addToValue(-((float)ModConfig.SANITY.sleepDeprivationDebuff) * (float)(record.getTicksAwake() - ModConfig.SANITY.sleepDeprivationMin) / (float)(ModConfig.SANITY.sleepDeprivationMax - ModConfig.SANITY.sleepDeprivationMin));
        }
    }

    public static void playStaticNoise(SanityRecord record, EntityPlayer player) {
        float threshold = (float)ModConfig.SANITY.hallucinationThreshold * ((Float)SanityRecord.values.upperEndpoint()).floatValue();
        if (player.field_70170_p.func_72820_D() % 160L == 0L) {
            Minecraft client = Minecraft.func_71410_x();
            if (player != client.field_71439_g) {
                return;
            }
            if (player.field_70170_p.field_73012_v.nextFloat() < 0.25f && record.getValue() < threshold) {
                float volume = (1.0f - record.getValue() / threshold) * (float)ModConfig.SANITY.staticBuzzIntensity;
                player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, staticbuzz, SoundCategory.AMBIENT, volume, 1.0f, false);
                client.field_71460_t.func_175069_a(distortshader);
            } else {
                ShaderGroup shader = client.field_71460_t.func_147706_e();
                if (shader != null && shader.func_148022_b().equals(distortshader.toString())) {
                    client.field_71460_t.func_181022_b();
                }
            }
        }
    }

    public static void whenInDark(SanityRecord record, EntityPlayer player) {
        BlockPos position = new BlockPos(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0));
        int lightlevel = player.field_70170_p.func_175699_k(position);
        if (lightlevel < ModConfig.SANITY.comfortLightLevel) {
            float darknesslevel = (float)(ModConfig.SANITY.comfortLightLevel - lightlevel) / (float)ModConfig.SANITY.comfortLightLevel;
            record.addToValue((float)ModConfig.SANITY.darkSpookFactorBase * -darknesslevel);
        }
    }

    public static void whenWet(SanityRecord record, EntityPlayer player) {
        float boundary = (float)ModConfig.SANITY.wetnessAnnoyanceThreshold;
        StatTracker stats = (StatTracker)player.getCapability(StatCapability.target, null);
        SimpleStatRecord wetness = stats.getRecord(WetnessModifier.instance);
        if (wetness.getNormalizedValue() > boundary) {
            record.addToValue((wetness.getNormalizedValue() - boundary) / (1.0f - boundary) * -((float)ModConfig.SANITY.maxWetnessAnnoyance));
        }
    }

    public static void whenNearEntities(SanityRecord record, EntityPlayer player) {
        BlockPos origin = player.func_180425_c();
        Vec3i offset = new Vec3i(3, 3, 3);
        AxisAlignedBB box = new AxisAlignedBB(origin.func_177973_b(offset), origin.func_177971_a(offset));
        List entities = player.field_70170_p.func_72872_a(EntityCreature.class, box);
        float value = record.getValue();
        for (EntityCreature creature : entities) {
            if (creature instanceof EntityTameable) {
                EntityTameable pet = (EntityTameable)creature;
                float bonus = pet.func_70909_n() ? (float)ModConfig.SANITY.tamedMobMultiplier : 1.0f;
                value = (float)((double)value + ModConfig.SANITY.friendlyMobBonus * (double)bonus);
                continue;
            }
            if (creature instanceof EntityAnimal) {
                value = (float)((double)value + ModConfig.SANITY.friendlyMobBonus);
                continue;
            }
            if (!(creature instanceof EntityMob)) continue;
            value = (float)((double)value - ModConfig.SANITY.hostileMobModifier);
        }
        record.setValue(value);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onClientWorldTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer()) {
            return;
        }
        Minecraft client = Minecraft.func_71410_x();
        ShaderGroup shader = client.field_71460_t.func_147706_e();
        StatTracker tracker = (StatTracker)event.player.getCapability(StatCapability.target, null);
        if (shader != null && event.player.field_70170_p.func_72820_D() % 160L == 0L && shader.func_148022_b().equals(distortshader.toString()) && !tracker.isActive(instance, null)) {
            client.field_71460_t.func_181022_b();
        }
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)staticbuzz);
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (event.shouldSetSpawn()) {
            StatTracker stats = (StatTracker)player.getCapability(StatCapability.target, null);
            SanityRecord sanity = stats.getRecord(instance);
            sanity.addToValue(((Float)sanity.getValueRange().upperEndpoint()).floatValue() * (float)ModConfig.SANITY.sleepResoration);
            sanity.resetSleep();
            SurvivalInc.proxy.net.sendToAll((IMessage)new StatSyncMessage(player));
            player.func_71024_bL().func_75114_a(player.func_71024_bL().func_75116_a() - 8);
        }
    }

    @SubscribeEvent
    public static void onConsumeItem(LivingEntityUseItemEvent.Finish event) {
        Entity ent = event.getEntity();
        if (ent instanceof EntityPlayer) {
            try {
                float mod = SanityModifier.instance.foodSanityMap.get(event.getItem().func_77973_b()).floatValue();
                EntityPlayer player = (EntityPlayer)ent;
                StatTracker stats = (StatTracker)player.getCapability(StatCapability.target, null);
                SimpleStatRecord sanity = stats.getRecord(instance);
                sanity.addToValue(mod);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onTame(AnimalTameEvent event) {
        Entity ent = event.getEntity();
        if (ent instanceof EntityPlayer) {
            StatTracker stat = (StatTracker)ent.getCapability(StatCapability.target, null);
            SimpleStatRecord sanity = stat.getRecord(instance);
            sanity.addToValue((float)ModConfig.SANITY.animalTameBoost);
        }
    }
}

