/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats.impl;

import com.google.common.collect.Range;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import enginecrafter77.survivalinc.stats.StatProvider;
import enginecrafter77.survivalinc.stats.StatRecord;
import enginecrafter77.survivalinc.stats.StatRegisterEvent;
import enginecrafter77.survivalinc.stats.effect.EffectApplicator;
import enginecrafter77.survivalinc.stats.effect.FunctionalEffectFilter;
import enginecrafter77.survivalinc.stats.effect.SideEffectFilter;
import enginecrafter77.survivalinc.stats.effect.ValueStatEffect;
import enginecrafter77.survivalinc.stats.impl.HydrationModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WetnessModifier
implements StatProvider<SimpleStatRecord> {
    private static final long serialVersionUID = -4227255838351827965L;
    public static final WetnessModifier instance = new WetnessModifier();
    public final Map<Block, Float> humiditymap = new HashMap<Block, Float>();
    public final EffectApplicator<SimpleStatRecord> effects;
    public final UUID wetnessSlowdown = UUID.nameUUIDFromBytes(this.getStatID().toString().getBytes());

    public WetnessModifier() {
        this.effects = new EffectApplicator();
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register(WetnessModifier.class);
        this.effects.add(new ValueStatEffect(ValueStatEffect.Operation.OFFSET, 0.01f)).addFilter(FunctionalEffectFilter.byPlayer(player -> player.field_70170_p.func_175727_C(player.func_180425_c().func_177984_a())));
        this.effects.add(new ValueStatEffect(ValueStatEffect.Operation.OFFSET, -0.8f)).addFilter(FunctionalEffectFilter.byPlayer(Entity::func_70027_ad));
        this.effects.add(new ValueStatEffect(ValueStatEffect.Operation.OFFSET, -0.08f)).addFilter(HydrationModifier.isOutsideOverworld);
        this.effects.add(WetnessModifier::scanSurroundings);
        this.effects.add(WetnessModifier::naturalDrying).addFilter(FunctionalEffectFilter.byPlayer(Entity::func_70026_G).invert());
        this.effects.add(WetnessModifier::whenInWater).addFilter(FunctionalEffectFilter.byPlayer(Entity::func_70090_H));
        this.effects.add(WetnessModifier::slowDown).addFilter(SideEffectFilter.SERVER);
        this.humiditymap.put((Block)Blocks.field_150480_ab, Float.valueOf(-0.5f));
        this.humiditymap.put((Block)Blocks.field_150353_l, Float.valueOf(-1.0f));
        this.humiditymap.put((Block)Blocks.field_150356_k, Float.valueOf(-1.0f));
        this.humiditymap.put(Blocks.field_150470_am, Float.valueOf(-0.4f));
        this.humiditymap.put(Blocks.field_189877_df, Float.valueOf(-0.4f));
    }

    @Override
    public void update(EntityPlayer target, StatRecord record) {
        SimpleStatRecord wetness = (SimpleStatRecord)record;
        this.effects.apply(wetness, target);
        wetness.checkoutValueChange();
    }

    @Override
    public ResourceLocation getStatID() {
        return new ResourceLocation("survivalinc", "wetness");
    }

    @Override
    public SimpleStatRecord createNewRecord() {
        SimpleStatRecord record = new SimpleStatRecord();
        record.setValueRange((Range<Float>)Range.closed((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(100.0f)));
        return record;
    }

    @Override
    public Class<SimpleStatRecord> getRecordClass() {
        return SimpleStatRecord.class;
    }

    @SubscribeEvent
    public static void registerStat(StatRegisterEvent event) {
        event.register(instance);
    }

    public static void slowDown(SimpleStatRecord record, EntityPlayer player) {
        IAttributeInstance inst = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        inst.func_188479_b(WetnessModifier.instance.wetnessSlowdown);
        IBlockState ground = player.field_70170_p.func_180495_p(player.func_180425_c().func_177977_b());
        if (!(ground.func_177230_c() instanceof BlockLiquid) && !player.func_70090_H()) {
            float mod = (float)(-Math.pow(record.getNormalizedValue(), 0.3333333432674408) * (1.0 - ModConfig.WETNESS.minimalWalkSpeed));
            if (Math.log10(mod) < -3.0) {
                mod = 0.0f;
            }
            inst.func_111121_a(new AttributeModifier(WetnessModifier.instance.wetnessSlowdown, "wetnessSlowdown", (double)mod, 2).func_111168_a(false));
        }
    }

    public static void whenInWater(SimpleStatRecord record, EntityPlayer player) {
        Material headBlockMaterial = player.field_70170_p.func_180495_p(new BlockPos((Entity)player).func_177984_a()).func_185904_a();
        if (headBlockMaterial == Material.field_151586_h) {
            record.addToValue(5.0f);
        } else if (record.getNormalizedValue() < 0.4f) {
            record.addToValue(1.25f);
        }
    }

    public static void naturalDrying(SimpleStatRecord record, EntityPlayer player) {
        float difference = record.getValue() / (float)ModConfig.WETNESS.drainingFactor;
        record.addToValue(-difference);
        if (player.field_70170_p.field_72995_K) {
            WorldClient world = (WorldClient)player.field_70170_p;
            Random rng = world.field_73012_v;
            for (int index = Math.round(4.0f * difference); index > 0; --index) {
                world.func_175688_a(EnumParticleTypes.DRIP_WATER, player.field_70165_t + ((double)rng.nextFloat() * 0.5 - 0.25), player.field_70163_u + ((double)(rng.nextFloat() * 1.0f) + 0.25), player.field_70161_v + ((double)rng.nextFloat() * 0.5 - 0.25), player.field_70159_w, -0.5, player.field_70179_y, new int[0]);
            }
        }
    }

    public static void scanSurroundings(SimpleStatRecord record, EntityPlayer player) {
        Vec3i offset = new Vec3i(2, 1, 2);
        BlockPos origin = new BlockPos((Entity)player);
        Iterable blocks = BlockPos.func_177980_a((BlockPos)origin.func_177973_b(offset), (BlockPos)origin.func_177971_a(offset));
        float diff = 0.0f;
        for (BlockPos position : blocks) {
            Block block = player.field_70170_p.func_180495_p(position).func_177230_c();
            if (!WetnessModifier.instance.humiditymap.containsKey(block)) continue;
            float basewetness = WetnessModifier.instance.humiditymap.get(block).floatValue();
            float proximity = (float)Math.sqrt(position.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v));
            diff += basewetness / proximity;
        }
        if (player.func_70026_G()) {
            diff /= 2.0f;
        }
        record.addToValue(diff);
    }
}

