/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.TankReference;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class ElementProgressRender {
    private static final ResourceLocation ICONS = new ResourceLocation("textures/gui/icons.png");

    public static void render(IProgressStyle style, long current, long max, MatrixStack matrixStack, int x, int y, int w, int h) {
        if (style.isLifeBar()) {
            ElementProgressRender.renderLifeBar(current, matrixStack, x, y, w, h);
        } else if (style.isArmorBar()) {
            ElementProgressRender.renderArmorBar(current, matrixStack, x, y, w, h);
        } else {
            RenderHelper.drawThickBeveledBox(matrixStack, x, y, x + w, y + h, 1, style.getBorderColor(), style.getBorderColor(), style.getBackgroundColor());
            if (current > 0L && max > 0L) {
                int dx = (int)Math.min(current * (long)(w - 2) / max, (long)(w - 2));
                if (style.getFilledColor() == style.getAlternatefilledColor()) {
                    if (dx > 0) {
                        RenderHelper.drawThickBeveledBox(matrixStack, x + 1, y + 1, x + dx + 1, y + h - 1, 1, style.getFilledColor(), style.getFilledColor(), style.getFilledColor());
                    }
                } else {
                    for (int xx = x + 1; xx < x + dx + 1; ++xx) {
                        int color = (xx & 1) == 0 ? style.getFilledColor() : style.getAlternatefilledColor();
                        RenderHelper.drawVerticalLine(matrixStack, xx, y + 1, y + h - 1, color);
                    }
                }
            }
        }
        ElementProgressRender.renderText(matrixStack, x, y, w, current, style);
    }

    private static void renderText(MatrixStack matrixStack, int x, int y, int w, long current, IProgressStyle style) {
        if (style.isShowText()) {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer render = mc.field_71466_p;
            IFormattableTextComponent s = style.getPrefixComp().func_230532_e_().func_230529_a_(ElementProgress.format(current, style.getNumberFormat(), style.getSuffixComp()));
            int textWidth = render.func_243245_a(s.func_241878_f());
            switch (style.getAlignment()) {
                case ALIGN_BOTTOMRIGHT: {
                    RenderHelper.renderText(mc, matrixStack, x + w - 3 - textWidth, y + 2, (ITextComponent)s);
                    break;
                }
                case ALIGN_CENTER: {
                    RenderHelper.renderText(mc, matrixStack, x + w / 2 - textWidth / 2, y + 2, (ITextComponent)s);
                    break;
                }
                case ALIGN_TOPLEFT: {
                    RenderHelper.renderText(mc, matrixStack, x + 3, y + 2, (ITextComponent)s);
                }
            }
        }
    }

    private static void renderLifeBar(long current, MatrixStack matrixStack, int x, int y, int w, int h) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ICONS);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        if (current * 4L >= (long)w) {
            RenderHelper.drawTexturedModalRect(matrix, x, y, 52, 0, 9, 9);
            RenderHelper.renderText(Minecraft.func_71410_x(), matrixStack, x + 12, y, TextFormatting.WHITE + String.valueOf(current / 2L));
        } else {
            int i = 0;
            while ((long)i < current / 2L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 52, 0, 9, 9);
                x += 8;
                ++i;
            }
            if (current % 2L != 0L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 61, 0, 9, 9);
            }
        }
    }

    private static void renderArmorBar(long current, MatrixStack matrixStack, int x, int y, int w, int h) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ICONS);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        if (current * 4L >= (long)w) {
            RenderHelper.drawTexturedModalRect(matrix, x, y, 43, 9, 9, 9);
            RenderHelper.renderText(Minecraft.func_71410_x(), matrixStack, x + 12, y, TextFormatting.WHITE + String.valueOf(current / 2L));
        } else {
            int i = 0;
            while ((long)i < current / 2L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 43, 9, 9, 9);
                x += 8;
                ++i;
            }
            if (current % 2L != 0L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 25, 9, 9, 9);
            }
        }
    }

    public static void renderTank(MatrixStack matrixStack, int x, int y, int width, int height, IProgressStyle style, TankReference tank) {
        RenderHelper.drawThickBeveledBox(matrixStack, x, y, x + width, y + height, 1, style.getBorderColor(), style.getBorderColor(), style.getBackgroundColor());
        if (tank.getStored() <= 0) {
            if (style.isShowText()) {
                ElementProgressRender.renderText(matrixStack, x, y, width, 0L, style);
            }
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        Function map = mc.func_228015_a_(PlayerContainer.field_226615_c_);
        width -= 2;
        FluidStack[] fluids = tank.getFluids();
        int start = 1;
        int tanks = fluids.length;
        int max = tank.getCapacity();
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        for (int i = 0; i < tanks; ++i) {
            FluidAttributes attr;
            TextureAtlasSprite liquidIcon;
            FluidStack stack = fluids[i];
            int lvl = (int)(stack == null ? 0.0 : (double)stack.getAmount() / (double)max * (double)width);
            if (lvl == 0 || (liquidIcon = (TextureAtlasSprite)map.apply((attr = stack.getFluid().getAttributes()).getStillTexture(stack))) == map.apply(MissingTextureSprite.func_195675_b())) continue;
            int color = attr.getColor(stack);
            RenderSystem.color4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
            while (lvl != 0) {
                int maxX = Math.min(16, lvl);
                lvl -= maxX;
                RenderHelper.drawTexturedModalRect(matrix, x + start, y + 1, liquidIcon, maxX, height - 2);
                start += maxX;
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ElementProgressRender.renderText(matrixStack, x, y, width + 2, tank.getStored(), style);
    }
}

