/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChestInfoTools {
    static void showChestInfo(ProbeMode mode, IProbeInfo probeInfo, World world, BlockPos pos, IProbeConfig config) {
        ArrayList<Object> stacks = null;
        IProbeConfig.ConfigMode chestMode = config.getShowChestContents();
        if (!(chestMode != IProbeConfig.ConfigMode.EXTENDED || (Integer)Config.showSmallChestContentsWithoutSneaking.get() <= 0 && Config.getInventoriesToShow().isEmpty())) {
            int slots;
            if (Config.getInventoriesToShow().contains(world.func_180495_p(pos).func_177230_c().getRegistryName())) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            } else if ((Integer)Config.showSmallChestContentsWithoutSneaking.get() > 0 && (slots = ChestInfoTools.getChestContents(world, pos, stacks = new ArrayList())) <= (Integer)Config.showSmallChestContentsWithoutSneaking.get()) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            }
        } else if (chestMode == IProbeConfig.ConfigMode.NORMAL && !Config.getInventoriesToNotShow().isEmpty() && Config.getInventoriesToNotShow().contains(world.func_180495_p(pos).func_177230_c().getRegistryName())) {
            chestMode = IProbeConfig.ConfigMode.EXTENDED;
        }
        if (Tools.show(mode, chestMode)) {
            if (stacks == null) {
                stacks = new ArrayList<ItemStack>();
                ChestInfoTools.getChestContents(world, pos, stacks);
            }
            if (!stacks.isEmpty()) {
                boolean showDetailed = Tools.show(mode, config.getShowChestContentsDetailed()) && stacks.size() <= (Integer)Config.showItemDetailThresshold.get();
                ChestInfoTools.showChestContents(probeInfo, world, pos, stacks, showDetailed);
            }
        }
    }

    private static void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (foundItems != null && foundItems.contains(stack.func_77973_b())) {
            for (ItemStack s : stacks) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                s.func_190917_f(stack.func_190916_E());
                return;
            }
        }
        stacks.add(stack.func_77946_l());
        if (foundItems != null) {
            foundItems.add(stack.func_77973_b());
        }
    }

    private static void showChestContents(IProbeInfo probeInfo, World world, BlockPos pos, List<ItemStack> stacks, boolean detailed) {
        IProbeInfo vertical = null;
        IProbeInfo horizontal = null;
        int rows = 0;
        int idx = 0;
        vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Config.chestContentsBorderColor).spacing(0));
        if (detailed) {
            for (ItemStack stackInSlot : stacks) {
                horizontal = vertical.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.item(stackInSlot, new ItemStyle().width(16).height(16)).text(CompoundText.create().info(stackInSlot.func_77977_a()));
            }
        } else {
            for (ItemStack stackInSlot : stacks) {
                if (idx % 10 == 0) {
                    horizontal = vertical.horizontal(new LayoutStyle().spacing(0));
                    if (++rows > 4) break;
                }
                horizontal.item(stackInSlot);
                ++idx;
            }
        }
    }

    private static int getChestContents(World world, BlockPos pos, List<ItemStack> stacks) {
        TileEntity te = world.func_175625_s(pos);
        HashSet<Item> foundItems = (Boolean)Config.compactEqualStacks.get() != false ? new HashSet<Item>() : null;
        AtomicInteger maxSlots = new AtomicInteger();
        try {
            if (te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(capability -> {
                    maxSlots.set(capability.getSlots());
                    for (int i = 0; i < maxSlots.get(); ++i) {
                        ChestInfoTools.addItemStack(stacks, foundItems, capability.getStackInSlot(i));
                    }
                });
            } else if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                maxSlots.set(inventory.func_70302_i_());
                for (int i = 0; i < maxSlots.get(); ++i) {
                    ChestInfoTools.addItemStack(stacks, foundItems, inventory.func_70301_a(i));
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Getting the contents of a " + world.func_180495_p(pos).func_177230_c().getRegistryName() + " (" + te.getClass().getName() + ")", e);
        }
        return maxSlots.get();
    }
}

