/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;

public class BlockDecorativeGrave
extends BlockGraveBase<TileEntityDecorativeGrave> {
    public static final BooleanProperty HAS_SOUL = BooleanProperty.func_177716_a((String)"has_soul");

    public BlockDecorativeGrave(GraveModel graveModel) {
        super(BlockDecorativeGrave.getBuilder(), graveModel);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)HAS_SOUL, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected TileEntityDecorativeGrave createTileGrave(BlockState state, IBlockReader world) {
        return new TileEntityDecorativeGrave();
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        IntStream.rangeClosed(0, 1).mapToObj(textureId -> ItemBlockGrave.createDecorativeStack(this.graveModel, textureId)).forEach(arg_0 -> items.add(arg_0));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HAS_SOUL});
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return (Boolean)SharedConfigTombstone.decorative_grave.unbreakableDecorativeGrave.get() == false;
    }

    public boolean isToolEffective(BlockState state, ToolType type) {
        return type == ToolType.PICKAXE || type == ToolType.SHOVEL;
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ShovelItem) && !(stack.func_77973_b() instanceof PickaxeItem)) {
            return super.canHarvestBlock(state, world, pos, player);
        }
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult rayTrace) {
        LazyOptional soulConsumerHolder;
        if (!EntityHelper.isValidPlayer(playerIn)) {
            return ActionResultType.FAIL;
        }
        if (hand != Hand.MAIN_HAND || playerIn.func_184614_ca().func_190926_b()) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = playerIn.func_184614_ca();
        if (playerIn.field_70170_p.field_72995_K) {
            return !EntityHelper.hasCooldown(playerIn, stack) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)playerIn;
        boolean isSoulReceptacle = stack.func_77973_b() == ModItems.soul_receptacle;
        LazyOptional lazyOptional = soulConsumerHolder = isSoulReceptacle ? LazyOptional.empty() : stack.getCapability(TBSoulConsumerProvider.CAP_SOUL_CONSUMER);
        if (!isSoulReceptacle && !soulConsumerHolder.isPresent()) {
            return super.func_225533_a_(state, world, pos, (PlayerEntity)serverPlayer, hand, rayTrace);
        }
        if (!EntityHelper.hasCooldown((PlayerEntity)serverPlayer, stack)) {
            if (isSoulReceptacle) {
                EntityHelper.setCooldown((PlayerEntity)serverPlayer, stack, 10);
                if (((Boolean)state.func_177229_b((Property)HAS_SOUL)).booleanValue()) {
                    LangKey.MESSAGE_FREESOUL_FAILED.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
                    return super.func_225533_a_(state, world, pos, (PlayerEntity)serverPlayer, hand, rayTrace);
                }
                LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
                lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)pos));
                lightningboltentity.func_233623_a_(true);
                ((ServerWorld)world).func_217376_c((Entity)lightningboltentity);
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_SOUL, (Comparable)Boolean.valueOf(true)), 3);
                LangKey.MESSAGE_FREESOUL_SUCCESS.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
                if (!serverPlayer.func_184812_l_()) {
                    serverPlayer.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                }
                EntityHelper.addKnowledge(serverPlayer, 10L);
                EntityHelper.addAlignment(serverPlayer, (Integer)ConfigTombstone.alignment.pointsFreeSoulReceptacle.get());
                return ActionResultType.SUCCESS;
            }
            soulConsumerHolder.ifPresent(soulConsumer -> {
                if (soulConsumer.isEnchanted(stack)) {
                    LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
                } else if (((Boolean)state.func_177229_b((Property)HAS_SOUL)).booleanValue()) {
                    if (soulConsumer.canEnchant(world, pos, (PlayerEntity)serverPlayer, stack)) {
                        if (soulConsumer.setEnchant(world, pos, (PlayerEntity)serverPlayer, stack)) {
                            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_SOUL, (Comparable)Boolean.valueOf(false)), 3);
                            TileEntityDecorativeGrave tile = (TileEntityDecorativeGrave)((Object)((Object)this.getTileEntity(world, pos)));
                            if (tile != null) {
                                tile.resetCheckSoul();
                            }
                            ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundCategory.PLAYERS, world, serverPlayer.func_233580_cy_(), 0.5f, 0.5f);
                            serverPlayer.func_145747_a(soulConsumer.getEnchantSuccessMessage((PlayerEntity)serverPlayer), Util.field_240973_b_);
                            ModTriggers.ACTIVATE_MAGIC_ITEM.trigger(serverPlayer);
                            EntityHelper.addKnowledge(serverPlayer, soulConsumer.getKnowledge());
                        } else {
                            serverPlayer.func_145747_a(soulConsumer.getEnchantFailedMessage((PlayerEntity)serverPlayer), Util.field_240973_b_);
                        }
                    } else {
                        LangKey.MESSAGE_ENCHANT_ITEM_NOT_ALLOWED.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
                    }
                } else {
                    LangKey.MESSAGE_ENCHANT_ITEM_NO_SOUL.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
                }
            });
            EntityHelper.setCooldown((PlayerEntity)serverPlayer, stack, 10);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        ItemStack stack;
        if (entity.func_225608_bj_() && !entity.field_70128_L && TimeHelper.atInterval(entity.field_70173_aa, 20) && EntityHelper.isValidPlayer(entity) && !(stack = ((PlayerEntity)entity).func_184614_ca()).func_190926_b()) {
            stack.getCapability(TBSoulConsumerProvider.CAP_SOUL_CONSUMER).ifPresent(soulConsumer -> soulConsumer.onSneakGrave(world, pos, (PlayerEntity)entity, stack));
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        String engravedName = "";
        TileEntity tile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof TileEntityDecorativeGrave) {
            engravedName = ((TileEntityDecorativeGrave)tile).getOwnerName();
        }
        drops.add(ItemBlockGrave.createDecorativeStack(this.graveModel, (Integer)state.func_177229_b((Property)MODEL_TEXTURE), engravedName));
        return drops;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        Helper.removeNoEvent(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntityDecorativeGrave tile;
        String engraved_name;
        if (!world.field_72995_K && !(engraved_name = NBTStackHelper.getString(stack, "engraved_name")).isEmpty() && (tile = (TileEntityDecorativeGrave)((Object)this.getTileEntity(world, pos))) != null) {
            tile.setOwner(engraved_name, new Date().getTime());
        }
    }

    private static AbstractBlock.Properties getBuilder() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 1.8E7f).func_235838_a_(s -> 3).func_200947_a(SoundType.field_185851_d);
    }
}

