/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public class BlockGraveMarble
extends Block {
    public final String name;
    private final MarbleType type;

    public BlockGraveMarble(MarbleType type) {
        super(BlockGraveMarble.getBuilder());
        this.name = type.func_176610_l() + "_marble";
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)LangKey.MESSAGE_CRAFTING_INGREDIENT.getText(StyleType.TOOLTIP_DESC, new Object[0]));
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    public String func_149739_a() {
        return "tombstone.block." + this.name;
    }

    private static AbstractBlock.Properties getBuilder() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 1.8E7f).func_235838_a_(s -> 0).func_200947_a(SoundType.field_185851_d);
    }

    public static enum MarbleType implements IStringSerializable
    {
        DARK,
        WHITE;


        public static MarbleType byId(int id) {
            return id >= 0 && id < MarbleType.values().length ? MarbleType.values()[id] : DARK;
        }

        public static MarbleType getDefault() {
            return DARK;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

