/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModTabs;

public class ItemBlockGrave
extends BlockItem {
    public static final int MAX_MODEL_TEXTURE = 1;

    public ItemBlockGrave(Block grave) {
        super(grave, new Item.Properties().func_200916_a(ModTabs.mainTab).func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        String engravedName = ItemBlockGrave.getEngravedName(stack);
        if (engravedName.isEmpty()) {
            tooltip.add((ITextComponent)LangKey.MESSAGE_ENGRAVABLE.getText(StyleType.TOOLTIP_DESC, new Object[]{new StringTextComponent("[" + I18n.func_135052_a((String)Items.field_151042_j.func_77658_a(), (Object[])new Object[0]) + "]").func_240703_c_(StyleType.TOOLTIP_ITEM)}));
        } else {
            tooltip.add((ITextComponent)LangKey.MESSAGE_ENGRAVED.getText(StyleType.TOOLTIP_DESC, new Object[]{new StringTextComponent('\"' + engravedName + '\"').func_230530_a_(StyleType.TOOLTIP_ITEM)}));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        TranslationTextComponent baseTranslation = new TranslationTextComponent(this.func_77658_a());
        return ItemBlockGrave.getEngravedName(stack).isEmpty() ? baseTranslation : LangKey.MESSAGE_ENGRAVED_ITEM.getText(StyleType.MESSAGE_SPECIAL, new Object[]{baseTranslation});
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        return context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()).func_215686_e((IBlockReader)context.func_195991_k(), context.func_195995_a().func_177977_b()) && super.func_195941_b(context, state);
    }

    public static boolean setEngravedName(ItemStack stack, String engraved_name) {
        if (stack.func_77973_b() instanceof ItemBlockGrave) {
            NBTStackHelper.setString(stack, "engraved_name", engraved_name);
            return true;
        }
        return false;
    }

    public static boolean isEngraved(ItemStack stack) {
        return !ItemBlockGrave.getEngravedName(stack).isEmpty();
    }

    public static String getEngravedName(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlockGrave ? NBTStackHelper.getString(stack, "engraved_name") : "";
    }

    public static ItemStack setModelTexture(ItemStack stack, int modelTexture) {
        if (stack.func_77973_b() instanceof ItemBlockGrave) {
            NBTStackHelper.setInteger(stack, "model_texture", MathHelper.func_76125_a((int)modelTexture, (int)0, (int)1));
        }
        return stack;
    }

    public static int getModelTexture(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlockGrave ? MathHelper.func_76125_a((int)NBTStackHelper.getInteger(stack, "model_texture"), (int)0, (int)1) : 0;
    }

    public static ItemStack createRandomDecorativeStack() {
        return ItemBlockGrave.createDecorativeStack(GraveModel.getRandom(), Helper.random.nextInt(1));
    }

    public static ItemStack createDecorativeStack(GraveModel graveModel, int textureId) {
        return ItemBlockGrave.createDecorativeStack(graveModel, textureId, "");
    }

    public static ItemStack createDecorativeStack(GraveModel model, int textureId, String engravedName) {
        ItemStack stack = ItemBlockGrave.setModelTexture(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)model)), textureId);
        return engravedName.isEmpty() ? stack : NBTStackHelper.setString(stack, "engraved_name", engravedName);
    }
}

