/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.ThreadedBackup;

public class CommandTBRecovery
extends TombstoneCommand {
    private static final Method methodWritePlayerData = ObfuscationReflectionHelper.findMethod(PlayerList.class, (String)"func_72391_b", (Class[])new Class[]{ServerPlayerEntity.class});
    private SuggestionProvider<CommandSource> SUGGESTION_UUID = (ctx, build) -> {
        File checkedDir = ((CommandSource)ctx.getSource()).func_197028_i().func_240776_a_(SAVE_FOLDER).toFile();
        File[] uuidDirs = checkedDir.listFiles((file, name) -> {
            boolean valid;
            boolean bl = valid = file.isDirectory() && name.contains("-");
            if (valid) {
                UUID uuid = UUID.fromString(name);
                if (((CommandSource)ctx.getSource()).func_197028_i().func_184103_al().func_177451_a(uuid) == null) {
                    return ((CommandSource)ctx.getSource()).func_197028_i().func_152358_ax().func_152652_a(uuid) != null;
                }
            }
            return false;
        });
        return ISuggestionProvider.func_197005_b(uuidDirs == null ? new ArrayList() : (Iterable)Arrays.stream(uuidDirs).map(File::getName).collect(Collectors.toList()), (SuggestionsBuilder)build);
    };
    private SuggestionProvider<CommandSource> SUGGESTION_LOAD_OFFLINE = (ctx, build) -> {
        File[] matchingFiles;
        List<Object> list = new ArrayList();
        File checkedFile = new File(((CommandSource)ctx.getSource()).func_197028_i().func_240776_a_(SAVE_FOLDER).toFile(), UUID.fromString(StringArgumentType.getString((CommandContext)ctx, (String)"uuid")) + "");
        if (checkedFile.exists() && (matchingFiles = checkedFile.listFiles((file, name) -> name.endsWith(".save"))) != null) {
            list = Arrays.stream(matchingFiles).map(p -> p.getName().replace(".save", "")).collect(Collectors.toList());
            list.add(".latest");
            list.add(".oldest");
        }
        return ISuggestionProvider.func_197005_b(list, (SuggestionsBuilder)build);
    };
    private SuggestionProvider<CommandSource> SUGGESTION_LOAD_PLAYER = (ctx, build) -> {
        File[] matchingFiles;
        ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)ctx, (String)"player");
        List<Object> list = new ArrayList();
        File checkedFile = new File(((CommandSource)ctx.getSource()).func_197028_i().func_240776_a_(SAVE_FOLDER).toFile(), player.func_110124_au() + "");
        if (checkedFile.exists() && (matchingFiles = checkedFile.listFiles((file, name) -> name.endsWith(".save"))) != null) {
            list = Arrays.stream(matchingFiles).map(p -> p.getName().replace(".save", "")).collect(Collectors.toList());
            list.add(".latest");
            list.add(".oldest");
        }
        return ISuggestionProvider.func_197005_b(list, (SuggestionsBuilder)build);
    };
    private static final FolderName SAVE_FOLDER = new FolderName("tombstone/saved_players");

    public CommandTBRecovery(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbrecovery";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.showUsage((CommandSource)c.getSource()));
        builder.then(SubCommand.SAVE_ALL_PLAYERS.literal().executes(c -> CommandTBRecovery.saveAllPlayers(((CommandSource)c.getSource()).func_197028_i(), success -> this.sendMessage((CommandSource)c.getSource(), (success != false ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).getText(new Object[0]), true))));
        builder.then(((LiteralArgumentBuilder)SubCommand.SAVE_PLAYER.literal().executes(c -> this.showUsage((CommandSource)c.getSource()))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> {
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)c, (String)"player");
            return CommandTBRecovery.savePlayer(player, success -> this.sendMessage((CommandSource)c.getSource(), (success != false ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getText(player.func_200200_C_()), false));
        })));
        builder.then(((LiteralArgumentBuilder)SubCommand.LOAD_OFFLINE.literal().executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"uuid", (ArgumentType)StringArgumentType.word()).suggests(this.SUGGESTION_UUID).executes(c -> {
            UUID uuid = UUID.fromString(StringArgumentType.getString((CommandContext)c, (String)"uuid"));
            GameProfile profil = ((CommandSource)c.getSource()).func_197028_i().func_152358_ax().func_152652_a(uuid);
            if (profil == null) {
                throw EntityArgument.field_197100_c.create();
            }
            if (((CommandSource)c.getSource()).func_197028_i().func_184103_al().func_177451_a(uuid) != null) {
                throw LangKey.MESSAGE_PLAYER_ONLINE.asCommandException(new Object[0]);
            }
            return this.recoverPlayerOffline((CommandSource)c.getSource(), profil, ".latest");
        })).then(Commands.func_197056_a((String)"file_string", (ArgumentType)StringArgumentType.word()).suggests(this.SUGGESTION_LOAD_OFFLINE).executes(c -> {
            UUID uuid = UUID.fromString(StringArgumentType.getString((CommandContext)c, (String)"uuid"));
            GameProfile profil = ((CommandSource)c.getSource()).func_197028_i().func_152358_ax().func_152652_a(uuid);
            if (profil == null) {
                throw EntityArgument.field_197100_c.create();
            }
            return this.recoverPlayerOffline((CommandSource)c.getSource(), profil, StringArgumentType.getString((CommandContext)c, (String)"file_string"));
        }))));
        builder.then(((LiteralArgumentBuilder)SubCommand.LOAD_PLAYER.literal().executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.loadPlayer((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), ".latest"))).then(Commands.func_197056_a((String)"file_string", (ArgumentType)StringArgumentType.word()).suggests(this.SUGGESTION_LOAD_PLAYER).executes(c -> this.loadPlayer((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), StringArgumentType.getString((CommandContext)c, (String)"file_string"))))));
        return builder;
    }

    public static int saveAllPlayers(MinecraftServer server, Consumer<Boolean> consumer) {
        File baseFolder = server.func_240776_a_(SAVE_FOLDER).toFile();
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            ModTombstone.LOGGER.info("The backup folder for players cannot be created");
            consumer.accept(false);
            return 1;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        boolean hasPlayerSkipped = false;
        for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
            if (!player.func_70089_S() || player.func_175149_v()) continue;
            File playerFolder = CommandTBRecovery.getPlayerFolder(player);
            if (playerFolder == null) {
                hasPlayerSkipped = true;
                continue;
            }
            pairs.add(Pair.of((Object)player.func_189511_e(new CompoundNBT()), (Object)playerFolder));
        }
        if (pairs.size() == 0) {
            consumer.accept(true);
            return 1;
        }
        boolean skipped = hasPlayerSkipped;
        ThreadedBackup.INSTANCE.queueBackup(() -> {
            boolean wasSuccessful = !skipped;
            for (Pair pair : pairs) {
                boolean success = CommandTBRecovery.savePlayerData((CompoundNBT)pair.getLeft(), (File)pair.getRight());
                if (success) continue;
                wasSuccessful = false;
            }
            boolean isSuccessful = wasSuccessful;
            server.func_213165_a(() -> consumer.accept(isSuccessful));
            return false;
        });
        return 1;
    }

    public static int savePlayer(ServerPlayerEntity player, Consumer<Boolean> consumer) {
        CommandTBRecovery.checkAlive((Entity)player);
        CommandTBRecovery.checkNotSpectator((PlayerEntity)player);
        File playerFolder = CommandTBRecovery.getPlayerFolder(player);
        if (playerFolder == null) {
            consumer.accept(false);
            return 1;
        }
        MinecraftServer listener = player.field_71133_b;
        CompoundNBT tag = player.func_189511_e(new CompoundNBT());
        ThreadedBackup.INSTANCE.queueBackup(() -> CommandTBRecovery.lambda$savePlayer$15(tag, playerFolder, (ThreadTaskExecutor)listener, consumer));
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean savePlayerData(CompoundNBT tag, File saveFolder) {
        String dateString = new SimpleDateFormat("yyyyMMdd-hhmmss", Locale.US).format(new Date());
        try (FileWriter writer = new FileWriter(new File(saveFolder, dateString + ".save"));){
            writer.write(tag.toString());
            writer.close();
            File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
            if (matchingFiles != null && matchingFiles.length > (Integer)ConfigTombstone.recovery.recoveryPlayerMaxSaves.get()) {
                int diff = matchingFiles.length - (Integer)ConfigTombstone.recovery.recoveryPlayerMaxSaves.get();
                Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                int num = 0;
                File[] fileArray = matchingFiles;
                int n = fileArray.length;
                for (int i = 0; i < n; ++num, ++i) {
                    File file2 = fileArray[i];
                    if (num >= diff) break;
                    file2.delete();
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    private static File getPlayerFolder(ServerPlayerEntity player) {
        File saveFolder = new File(player.field_71133_b.func_240776_a_(SAVE_FOLDER).toFile(), player.func_110124_au() + "");
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            ModTombstone.LOGGER.info("The backup folder cannot be created");
            return null;
        }
        return saveFolder;
    }

    private int recoverPlayerOffline(CommandSource sender, GameProfile profil, String fileString) {
        block16: {
            PlayerList playerList = sender.func_197028_i().func_184103_al();
            ServerPlayerEntity player = playerList.func_148545_a(profil);
            try (BufferedReader reader = new BufferedReader(new FileReader(this.getBackupFile(sender, profil.getId(), fileString)));){
                CompoundNBT nbt = JsonToNBT.func_180713_a((String)reader.readLine());
                reader.close();
                if (nbt.func_150296_c().isEmpty()) break block16;
                player.func_70020_e(nbt);
                try {
                    methodWritePlayerData.invoke((Object)sender.func_197028_i().func_184103_al(), player);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                this.sendMessage(sender, LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getText(player.func_200200_C_()), false);
            }
            catch (Exception e) {
                throw LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.asCommandException(player.func_200200_C_());
            }
        }
        return 1;
    }

    private int loadPlayer(CommandSource sender, ServerPlayerEntity player, String fileString) {
        block18: {
            CommandTBRecovery.checkAlive((Entity)player);
            CommandTBRecovery.checkNotSpectator((PlayerEntity)player);
            File file = this.getBackupFile(sender, player.func_110124_au(), fileString);
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                CompoundNBT nbt = JsonToNBT.func_180713_a((String)reader.readLine());
                reader.close();
                if (!nbt.func_150296_c().isEmpty()) {
                    ServerWorld targetWorld;
                    RegistryKey sourceDim = player.field_70170_p.func_234923_W_();
                    RegistryKey targetDim = NBTStackHelper.getWorldKey(nbt, "Dimension");
                    MinecraftServer server = sender.func_197028_i();
                    if (targetDim == null || (targetWorld = sender.func_197028_i().func_71218_a(targetDim)) == null) {
                        targetDim = World.field_234918_g_;
                        targetWorld = server.func_71218_a(targetDim);
                    }
                    ListNBT pos = nbt.func_150295_c("Pos", 6);
                    double x = pos.func_150309_d(0);
                    double y = pos.func_150309_d(1);
                    double z = pos.func_150309_d(2);
                    ListNBT rot = nbt.func_150295_c("Rotation", 5);
                    float yaw = rot.func_150308_e(0);
                    float pitch = rot.func_150308_e(1);
                    nbt.func_82580_o("Dimension");
                    nbt.func_82580_o("Pos");
                    nbt.func_82580_o("Rotation");
                    player.deserializeNBT(nbt);
                    player.func_200619_a(targetWorld, x, y, z, yaw, pitch);
                    if (sourceDim == targetDim) {
                        player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
                        for (EffectInstance potioneffect : player.func_70651_bq()) {
                            player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), potioneffect));
                        }
                    }
                    LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_TARGET_SUCCESS.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[0]);
                    this.sendMessage(sender, LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getText(player.func_200200_C_()), false);
                    break block18;
                }
                throw LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.asCommandException(player.func_200200_C_());
            }
            catch (Exception e) {
                throw LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.asCommandException(player.func_200200_C_());
            }
        }
        return 1;
    }

    private File getBackupFile(CommandSource sender, UUID id, String fileString) {
        String fileName;
        File saveFolder = new File(sender.func_197028_i().func_240776_a_(SAVE_FOLDER).toFile(), id + "");
        if (!saveFolder.exists()) {
            throw LangKey.MESSAGE_RECOVERY_NO_FOLDER.asCommandException(saveFolder.getAbsolutePath());
        }
        if (fileString.equals(".latest") || fileString.equals(".oldest")) {
            File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
            if (saveFiles == null || saveFiles.length == 0) {
                throw LangKey.MESSAGE_RECOVERY_NO_FILE.asCommandException(fileString);
            }
            Optional<File> res = fileString.equals(".latest") ? Stream.of(saveFiles).max(File::compareTo) : Stream.of(saveFiles).min(File::compareTo);
            fileName = res.get().getName();
        } else {
            fileName = fileString + ".save";
            File[] files = saveFolder.listFiles(p -> p.isFile() && p.getName().equals(fileName));
            if (files == null || files.length == 0) {
                throw LangKey.MESSAGE_RECOVERY_NO_FILE.asCommandException(fileName);
            }
        }
        return new File(saveFolder, fileName);
    }

    private static /* synthetic */ boolean lambda$savePlayer$15(CompoundNBT tag, File playerFolder, ThreadTaskExecutor listener, Consumer consumer) {
        boolean result = CommandTBRecovery.savePlayerData(tag, playerFolder);
        listener.func_213165_a(() -> consumer.accept(result));
        return false;
    }

    private static enum SubCommand implements ISubCommand
    {
        SAVE_ALL_PLAYERS,
        SAVE_PLAYER,
        LOAD_PLAYER,
        LOAD_OFFLINE;

    }
}

