/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.spawner.CustomVillageSiege;

public class CommandTBSiege
extends TombstoneCommand {
    public CommandTBSiege(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbsiege";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.launchSiege((CommandSource)c.getSource()));
        return builder;
    }

    private int launchSiege(CommandSource sender) {
        if (!((Boolean)ConfigTombstone.village_siege.handleVillageSiege.get()).booleanValue()) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerWorld world = sender.func_197028_i().func_71218_a(World.field_234918_g_);
        if (world == null) {
            throw LangKey.MESSAGE_UNLOADED_DIMENSION.asCommandException(new Object[0]);
        }
        if (world.func_72912_H().func_176130_y() == Difficulty.PEACEFUL) {
            throw LangKey.MESSAGE_DIFFICULTY_PEACEFUL.asCommandException(new Object[0]);
        }
        if (world.func_72935_r()) {
            throw LangKey.MESSAGE_ONLY_AT_NIGHT.asCommandException(new Object[0]);
        }
        CustomVillageSiege villageSiege = (CustomVillageSiege)world.field_241104_N_.stream().filter(spawner -> spawner instanceof CustomVillageSiege).findFirst().orElseThrow(() -> new CommandException((ITextComponent)new StringTextComponent("The Overworld chunk generator is not the vanilla one")));
        switch (villageSiege.field_75536_c) {
            case SIEGE_START: 
            case SPAWN_MOBS: {
                throw LangKey.MESSAGE_START_SIEGE_FAILED.asCommandException(new Object[0]);
            }
            case SIEGE_END: {
                villageSiege.hasFailedTrySiege = false;
                villageSiege.field_75536_c = CustomVillageSiege.SiegeState.SIEGE_START;
                this.sendMessage(sender, LangKey.MESSAGE_START_SIEGE_SUCCESS.getText(new Object[0]), false);
            }
        }
        return 1;
    }
}

