/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;

public class CommandTBTeleport
extends TombstoneCommand {
    public CommandTBTeleport(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbteleport";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.showUsage((CommandSource)c.getSource()));
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"source", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> this.showUsage((CommandSource)c.getSource()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> {
            Entity target = EntityArgument.func_197088_a((CommandContext)c, (String)"target");
            BlockPos targetPos = target.func_233580_cy_();
            return this.teleport((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"source"), targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), (ServerWorld)target.field_70170_p);
        }))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(c -> {
            Entity source = EntityArgument.func_197088_a((CommandContext)c, (String)"source");
            BlockPos pos = BlockPosArgument.func_197274_b((CommandContext)c, (String)"pos");
            return this.teleport((CommandSource)c.getSource(), source, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (ServerWorld)source.field_70170_p);
        })).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(c -> {
            BlockPos pos = BlockPosArgument.func_197274_b((CommandContext)c, (String)"pos");
            return this.teleport((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"source"), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), DimensionArgument.func_212592_a((CommandContext)c, (String)"dim"));
        }))));
        return builder;
    }

    private int teleport(CommandSource sender, Entity source, int x, int y, int z, ServerWorld targetWorld) {
        CommandTBTeleport.checkAlive(source);
        CommandTBTeleport.checkNotSpectator(source);
        Location sourceLoc = new Location(source);
        Location destLoc = new Location(x, y, z, (World)targetWorld);
        if (sourceLoc.equals(destLoc)) {
            throw LangKey.MESSAGE_SAME_LOCATION.asCommandException(new Object[0]);
        }
        CommandTBTeleport.checkValidPos((World)targetWorld, destLoc.getPos());
        destLoc = new SpawnHelper(targetWorld, Helper.getCloserValidPos((World)targetWorld, destLoc.getPos())).findSpawnPlace();
        if (destLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        Entity newEntity = Helper.teleportEntity(source, destLoc);
        if (EntityHelper.isValidPlayer(newEntity)) {
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)newEntity, StyleType.MESSAGE_SPELL, new Object[0]);
        }
        this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getText(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getText(new Object[0]), destLoc.x, destLoc.y, destLoc.z, destLoc.dim.func_240901_a_().toString()), false);
        return 1;
    }
}

