/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Random;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;

public class CommandTBTeleportBiome
extends TombstoneCommand {
    public CommandTBTeleportBiome(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbteleportbiome";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        ((LiteralArgumentBuilder)builder.executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"biome", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGESTION_BIOME).executes(c -> this.teleportBiome((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), this.getOrThrowBiome((CommandContext<CommandSource>)c, "biome")))).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(c -> this.teleportBiome((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), this.getOrThrowBiome((CommandContext<CommandSource>)c, "biome"), DimensionArgument.func_212592_a((CommandContext)c, (String)"dim"))))));
        return builder;
    }

    private int teleportBiome(CommandSource sender, Entity target, Biome biome) {
        return this.teleportBiome(sender, target, biome, (ServerWorld)target.field_70170_p);
    }

    private int teleportBiome(CommandSource sender, Entity target, Biome biome, ServerWorld world) {
        CommandTBTeleportBiome.checkAlive(target);
        CommandTBTeleportBiome.checkNotSpectator(target);
        if (biome.getRegistryName().equals((Object)Biomes.field_76783_v.func_240901_a_())) {
            throw LangKey.MESSAGE_NO_BIOME_FOR_DIMENSION.asCommandException(new Object[0]);
        }
        BlockPos startingPos = target.func_233580_cy_();
        Location biomePos = Location.ORIGIN;
        for (int nbTry = 0; biomePos.isOrigin() && nbTry < 3; ++nbTry) {
            startingPos = Helper.getCloserValidPos((World)world, startingPos.func_177963_a((double)nbTry * Helper.random.nextGaussian() * 5000.0, 0.0, (double)nbTry * Helper.random.nextGaussian() * 5000.0));
            biomePos = this.findNearestBiome(world, startingPos.func_177958_n(), startingPos.func_177956_o(), startingPos.func_177952_p(), 6400, 8, biome, Helper.random, true);
        }
        if (biomePos.isOrigin()) {
            throw LangKey.MESSAGE_NO_BIOME.asCommandException(new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(world, biomePos.getPos()).findSpawnPlace(false);
        if (spawnLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.runNextTick(() -> {
            Entity newEntity = Helper.teleportEntity(target, spawnLoc);
            this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getText(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getText(new Object[0]), spawnLoc.x, spawnLoc.y, spawnLoc.z, spawnLoc.dim.func_240901_a_().toString()), false);
            if (EntityHelper.isValidPlayer(newEntity)) {
                LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)newEntity, StyleType.MESSAGE_SPELL, new Object[0]);
            }
        });
        return 1;
    }

    private Location findNearestBiome(ServerWorld world, int x, int y, int z, int radius, int radiusStep, Biome biome, Random random, boolean onionSearch) {
        int radiusMin;
        BiomeProvider biomeProvider = world.func_72863_F().func_201711_g().func_202090_b();
        RegistryKey dimId = world.func_234923_W_();
        int xMin = x >> 2;
        int zMin = z >> 2;
        int radiusMax = radius >> 2;
        int yBiomeChunk = y >> 2;
        Location biomePos = Location.ORIGIN;
        int count = 0;
        for (int actualRadius = radiusMin = onionSearch ? 0 : radiusMax; actualRadius <= radiusMax; actualRadius += radiusStep) {
            for (int biomeStepZ = -actualRadius; biomeStepZ <= actualRadius; biomeStepZ += radiusStep) {
                boolean onEdgeZ = Math.abs(biomeStepZ) == actualRadius;
                for (int biomeStepX = -actualRadius; biomeStepX <= actualRadius; biomeStepX += radiusStep) {
                    if (onionSearch) {
                        boolean onEdgeX;
                        boolean bl = onEdgeX = Math.abs(biomeStepX) == actualRadius;
                        if (!onEdgeX && !onEdgeZ) continue;
                    }
                    int xBiomeChunk = xMin + biomeStepX;
                    int zBiomeChunk = zMin + biomeStepZ;
                    if (!biome.getRegistryName().equals((Object)biomeProvider.func_225526_b_(xBiomeChunk, yBiomeChunk, zBiomeChunk).getRegistryName())) continue;
                    if (biomePos.isOrigin() || random.nextInt(count + 1) == 0) {
                        biomePos = new Location(xBiomeChunk << 2, y, zBiomeChunk << 2, (RegistryKey<World>)dimId);
                        if (onionSearch) {
                            return biomePos;
                        }
                    }
                    ++count;
                }
            }
        }
        return biomePos;
    }
}

