/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

public class CommandTBTeleportGrave
extends TombstoneCommand {
    public CommandTBTeleportGrave(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbteleportgrave";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.teleportGrave((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), ((CommandSource)c.getSource()).func_197035_h()));
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportGrave((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), EntityArgument.func_197089_d((CommandContext)c, (String)"player")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportGrave((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), EntityArgument.func_197089_d((CommandContext)c, (String)"target")))));
        return builder;
    }

    private int teleportGrave(CommandSource sender, ServerPlayerEntity player, ServerPlayerEntity target) {
        ServerWorld world;
        CommandTBTeleportGrave.checkAlive((Entity)player);
        CommandTBTeleportGrave.checkNotSpectator((PlayerEntity)player);
        MinecraftServer server = sender.func_197028_i();
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        Location lastGrave = deathHandler.getLastGrave(target.func_146103_bH().getName());
        if (!lastGrave.isOrigin() && !((world = this.getOrThrowWorld(server, lastGrave.dim)).func_175625_s(lastGrave.getPos()) instanceof TileEntityGrave)) {
            deathHandler.removeGrave(lastGrave);
            lastGrave = Location.ORIGIN;
        }
        if (lastGrave.isOrigin() && (lastGrave = ModItems.grave_key.getTombPos(ModItems.grave_key.findFirstKeyInInventory((PlayerEntity)target))).isOrigin()) {
            throw LangKey.MESSAGE_NO_GRAVE.asCommandException(new Object[0]);
        }
        world = this.getOrThrowWorld(server, lastGrave.dim);
        CommandTBTeleportGrave.checkValidPos((World)world, lastGrave.getPos());
        ServerPlayerEntity newEntity = Helper.teleportToGrave(player, lastGrave);
        if (EntityHelper.isValidPlayer((Entity)newEntity)) {
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)newEntity, StyleType.MESSAGE_SPELL, new Object[0]);
        }
        this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getText(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getText(new Object[0]), lastGrave.x, lastGrave.y, lastGrave.z, lastGrave.dim.func_240901_a_().toString()), false);
        return 1;
    }
}

