/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public abstract class TombstoneEnchantment
extends Enchantment {
    private final String customName;

    TombstoneEnchantment(String name, Enchantment.Rarity rarity, EnchantmentType type, EquipmentSlotType[] slots) {
        super(rarity, type, slots);
        this.customName = name;
    }

    protected abstract boolean isEnabled();

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int lvl) {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<String> getTooltipInfos(ItemStack stack) {
        ArrayList<String> infos = new ArrayList<String>();
        if (stack.func_77973_b() == Items.field_151134_bR) {
            infos.add(Helper.getFormattingCode(StyleType.TOOLTIP_ENCHANT) + I18n.func_135052_a((String)(this.func_77320_a() + ".desc"), (Object[])new Object[0]));
        }
        if (!this.isEnabled()) {
            infos.add(LangKey.MESSAGE_DISABLED.getClientTranslationWithStyle(StyleType.COLOR_OFF, new Object[0]));
        }
        return infos;
    }

    public String func_77320_a() {
        return "enchantment.tombstone." + this.customName;
    }
}

