/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.text.StringTextComponent;
import ovh.corail.tombstone.gui.TBColorSelectionButton;

public class ColorButtonHandler {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private int r;
    private int g;
    private int b;
    private TBColorSelectionButton button1;
    private TBColorSelectionButton button2;
    private TBColorSelectionButton button3;

    ColorButtonHandler(GameSettings settings, List<Widget> list, List<IGuiEventListener> children, int x, int y, int width, int height, int r, int g, int b, String title, Consumer<Boolean> dirty) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.x = x;
        this.y = y;
        this.button1 = new TBColorSelectionButton(settings, x, y, width, height, new SliderPercentageOption(title + "_R", 0.0, 255.0, 1.0f, s -> this.r, (s, d) -> {
            this.r = d.intValue();
        }, (s, d) -> new StringTextComponent(title + "_R")), this::getMinColorR, this::getMaxColorR, dirty);
        list.add((Widget)this.button1);
        children.add((IGuiEventListener)this.button1);
        this.button2 = new TBColorSelectionButton(settings, x, y + 6, width, height, new SliderPercentageOption(title + "_G", 0.0, 255.0, 1.0f, s -> this.g, (s, d) -> {
            this.g = d.intValue();
        }, (s, d) -> new StringTextComponent(title + "_G")), this::getMinColorG, this::getMaxColorG, dirty);
        list.add((Widget)this.button2);
        children.add((IGuiEventListener)this.button2);
        this.button3 = new TBColorSelectionButton(settings, x, y + 12, width, height, new SliderPercentageOption(title + "_B", 0.0, 255.0, 1.0f, s -> this.b, (s, d) -> {
            this.b = d.intValue();
        }, (s, d) -> new StringTextComponent(title + "_B")), this::getMinColorB, this::getMaxColorB, dirty);
        list.add((Widget)this.button3);
        children.add((IGuiEventListener)this.button3);
        this.width = width;
        this.height = height + 6;
    }

    private int getMinColorR() {
        return this.g * 256 + this.b;
    }

    private int getMaxColorR() {
        return this.getMinColorR() + 0xFF0000;
    }

    private int getMinColorG() {
        return this.r * 65536 + this.b;
    }

    private int getMaxColorG() {
        return this.getMinColorG() + 65280;
    }

    private int getMinColorB() {
        return this.r * 65536 + this.g * 256;
    }

    private int getMaxColorB() {
        return this.getMinColorB() + 255;
    }

    public int getColor() {
        return 65536 * this.r + 256 * this.g + this.b;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    void enableButtons() {
        this.button1.field_230693_o_ = true;
        this.button1.field_230694_p_ = true;
        this.button2.field_230693_o_ = true;
        this.button2.field_230694_p_ = true;
        this.button3.field_230693_o_ = true;
        this.button3.field_230694_p_ = true;
    }

    void disableButtons() {
        this.button1.field_230693_o_ = false;
        this.button1.field_230694_p_ = false;
        this.button2.field_230693_o_ = false;
        this.button2.field_230694_p_ = false;
        this.button3.field_230693_o_ = false;
        this.button3.field_230694_p_ = false;
    }
}

