/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.gui.GuiConfig;
import ovh.corail.tombstone.gui.GuiInfo;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpgradePerkServerMessage;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class GuiKnowledge
extends TBScreen {
    private static final ResourceLocation GUI_BAR = new ResourceLocation("minecraft", "textures/gui/bars.png");
    private final ITBCapability cap;
    private final int iconSize = 16;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private int hoveredPerkLevel = 0;
    private final ItemStack stackSkull = new ItemStack((IItemProvider)ModItems.advancement[0]);
    private final ItemStack stackRevive = new ItemStack((IItemProvider)ModItems.advancement[7]);
    private final ItemStack stackAnkh = new ItemStack((IItemProvider)ModItems.advancement[3]);
    private final double alignmentPos;

    public GuiKnowledge(ITBCapability cap) {
        super((ITextComponent)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]));
        this.cap = cap;
        for (Perk perk : PerkRegistry.perkRegistry.getValues()) {
            if (Helper.isDisabledPerk(perk, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)) continue;
            this.icons.add(new PerkIcon(perk));
        }
        this.alignmentPos = this.getBarRatio();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int x = this.guiLeft + 15;
        int y = this.guiTop + 72;
        int i = 0;
        int spaceForIcon = this.icons.size() > 12 ? 22 : 31;
        int maxIconByLine = this.icons.size() > 12 ? 8 : 6;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setPosition(x + caseX * spaceForIcon, y);
            if (caseX == maxIconByLine - 1) {
                y += 30;
            }
            ++i;
        }
        this.func_230480_a_((Widget)new TBGuiButton(this.guiLeft + 10, this.guiBottom - 25, 70, 15, (ITextComponent)new TranslationTextComponent("tombstone.compendium.main.title"), pressable -> this.getMinecraft().func_147108_a((Screen)new GuiInfo(null))));
        this.func_230480_a_((Widget)new TBGuiButton(this.guiRight - 10 - 70, this.guiBottom - 25, 70, 15, (ITextComponent)LangKey.BUTTON_CONFIG.getText(new Object[0]), pressable -> this.getMinecraft().func_147108_a((Screen)new GuiConfig())));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.hoveredIcon != null) {
            if (mouseButton == 0) {
                int perkLevel = this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk);
                if (perkLevel < this.hoveredIcon.perk.getLevelMax() && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                    return true;
                }
            } else if (mouseButton == 1 && this.getMinecraft().field_71439_g.func_184812_l_() && this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk) > 0) {
                PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        this.func_230446_a_(matrixStack);
        this.hoveredIcon = this.icons.stream().filter(p -> p.contains(mouseX, mouseY)).findFirst().orElse(null);
        int totalPerkPoints = this.cap.getTotalPerkPoints();
        int usedPerkPoints = this.cap.getUsedPerkPoints((PlayerEntity)this.getMinecraft().field_71439_g);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        RenderSystem.pushMatrix();
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        ((Object)((Object)this)).getClass();
        this.func_238465_a_(matrixStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 4, -1);
        ((Object)((Object)this)).getClass();
        this.func_238465_a_(matrixStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 6, -1);
        String titleName = LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getClientTranslation(new Object[0]);
        float f = (float)this.halfWidth - (float)this.field_230712_o_.func_78256_a(titleName) / 2.0f;
        float f2 = (float)this.guiTop + 9.0f;
        ((Object)((Object)this)).getClass();
        this.field_230712_o_.func_238421_b_(matrixStack, titleName, f, f2, -1);
        ((Object)((Object)this)).getClass();
        this.func_238465_a_(matrixStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 18, -1);
        ((Object)((Object)this)).getClass();
        this.func_238465_a_(matrixStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 20, -1);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().field_71446_o.func_110577_a(GUI_BAR);
        GuiKnowledge.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)40.0f, (int)182, (int)5, (int)182, (int)256);
        GuiKnowledge.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)45.0f, (int)((int)(129.22 * (double)(this.cap.getKnowledge() - this.cap.getKnowledgeForLevel(totalPerkPoints)) / (double)this.cap.getKnowledgeToReachNextLevel(totalPerkPoints + 1))), (int)5, (int)182, (int)256);
        GuiKnowledge.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 31), (float)0.0f, (float)101.0f, (int)182, (int)3, (int)182, (int)256);
        int startAlignmentY = 44;
        GuiKnowledge.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Alignment", (int)this.halfWidth, (int)(this.guiTop + startAlignmentY - 4), (int)-1);
        GuiKnowledge.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 20), (int)(this.guiTop + startAlignmentY + 10), (int)(this.guiRight - 20), (int)(this.guiTop + startAlignmentY + 17), (int)-16777216);
        Helper.fillGradient(matrix, this.guiLeft + 21, this.guiTop + startAlignmentY + 11, this.halfWidth, this.guiTop + startAlignmentY + 16, -65536, -1, this.func_230927_p_(), true);
        Helper.fillGradient(matrix, this.halfWidth, this.guiTop + startAlignmentY + 11, this.guiRight - 21, this.guiTop + startAlignmentY + 16, -1, -16776961, this.func_230927_p_(), true);
        float step = (float)(this.xSize - 42) / 8.0f;
        for (int i = 0; i < 8; ++i) {
            if (i == 4) continue;
            this.func_238473_b_(matrixStack, this.guiLeft + 21 + (int)((float)i * step), this.guiTop + startAlignmentY + 10, this.guiTop + startAlignmentY + 16, -16777216);
        }
        this.field_230707_j_.func_180450_b(this.stackSkull, this.guiLeft + 10, this.guiTop + startAlignmentY + 5);
        this.field_230707_j_.func_180450_b(this.stackRevive, this.guiRight - 10 - 16, this.guiTop + startAlignmentY + 5);
        int adjust = (int)Math.round((double)(this.xSize - 42) / 2.0 * this.alignmentPos);
        this.field_230707_j_.func_180450_b(this.stackAnkh, this.halfWidth + adjust - 8, this.guiTop + startAlignmentY + 4);
        String levelString = this.leftPerkPoints + " / " + totalPerkPoints;
        float f3 = this.guiLeft + 48 - this.field_230712_o_.func_78256_a(levelString);
        float f4 = this.guiTop + 28;
        ((Object)((Object)this)).getClass();
        this.field_230712_o_.func_238421_b_(matrixStack, levelString, f3, f4, -1);
        for (PerkIcon icon : this.icons) {
            this.drawPerk(matrixStack, icon);
        }
        if (Helper.isContributor((PlayerEntity)this.getMinecraft().field_71439_g)) {
            float f5 = this.guiLeft + 30;
            float f6 = this.guiBottom - 45;
            ((Object)((Object)this)).getClass();
            this.field_230712_o_.func_238421_b_(matrixStack, "Contributor", f5, f6, 8858573);
        }
        if (Helper.isDateAroundHalloween()) {
            String halloweenString = "Halloween";
            float f7 = this.guiRight - 30 - this.field_230712_o_.func_78256_a(halloweenString);
            float f8 = this.guiBottom - 45;
            ((Object)((Object)this)).getClass();
            this.field_230712_o_.func_238421_b_(matrixStack, halloweenString, f7, f8, 8858573);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
        this.drawPerkTooltip(matrixStack);
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
        RenderSystem.popMatrix();
    }

    private double getBarRatio() {
        boolean isPositive = this.cap.getAlignmentValue() >= 0;
        int alignement = Math.abs(MathHelper.func_76125_a((int)this.cap.getAlignmentValue(), (int)this.cap.getAlignmentMinValue(), (int)this.cap.getAlignmentMaxValue()));
        double ratio = alignement > 300 ? 0.75 + 0.25 * (double)(alignement - 300) * 0.005 : (alignement > 150 ? 0.5 + 0.25 * (double)(alignement - 150) / 150.0 : (alignement > 50 ? 0.25 + 0.25 * (double)(alignement - 50) * 0.01 : 0.25 * (double)alignement * 0.02));
        return isPositive ? ratio : -ratio;
    }

    private void drawPerk(MatrixStack matrixStack, PerkIcon icon) {
        int n;
        int levelWithBonus = this.cap.getPerkLevelWithBonus((PlayerEntity)this.getMinecraft().field_71439_g, icon.perk);
        boolean isHovered = icon.equals(this.hoveredIcon);
        boolean isMax = this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, icon.perk) == icon.perk.getLevelMax();
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiKnowledge.func_238467_a_((MatrixStack)matrixStack, (int)(icon.getMinX() - 1), (int)(icon.getMinY() - 1), (int)(icon.getMaxX() + 1), (int)(icon.getMaxY() + 1 + 10), (int)-15329733);
        if (isHovered) {
            int n2;
            if (isMax) {
                ((Object)((Object)this)).getClass();
                n2 = -1980292;
            } else {
                n2 = -7096363;
            }
            int color = n2;
            this.func_238465_a_(matrixStack, icon.minX - 2, icon.maxX + 1, icon.minY - 2, color);
            this.func_238465_a_(matrixStack, icon.minX - 2, icon.maxX + 1, icon.minY + 27, color);
            this.func_238473_b_(matrixStack, icon.minX - 2, icon.minY - 2, icon.minY + 27, color);
            this.func_238473_b_(matrixStack, icon.minX + 17, icon.minY - 2, icon.minY + 27, color);
        }
        if (levelWithBonus == 0 && !isHovered) {
            this.func_238468_a_(matrixStack, icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -13421773, -13421773);
            RenderSystem.color4f((float)0.13f, (float)0.13f, (float)0.13f, (float)0.5f);
        } else {
            this.func_238468_a_(matrixStack, icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -16703669, -7096363);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        ResourceLocation texture = icon.perk.getIcon();
        if (texture != null) {
            this.getMinecraft().func_110434_K().func_110577_a(texture);
            GuiKnowledge.func_238463_a_((MatrixStack)matrixStack, (int)icon.getMinX(), (int)icon.getMinY(), (float)0.0f, (float)0.0f, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize);
        }
        boolean hasBonus = icon.perk.getLevelBonus((PlayerEntity)this.getMinecraft().field_71439_g) != 0;
        String string = "" + levelWithBonus;
        float f = (float)icon.getMinX() + (levelWithBonus > 9 ? 2.5f : 5.5f);
        float f2 = icon.getMinY() + 18;
        if (hasBonus) {
            ((Object)((Object)this)).getClass();
            n = 8858573;
        } else if (isMax) {
            ((Object)((Object)this)).getClass();
            n = -1980292;
        } else if (levelWithBonus > 0) {
            ((Object)((Object)this)).getClass();
            n = -12562177;
        } else {
            ((Object)((Object)this)).getClass();
            n = -8355712;
        }
        this.field_230712_o_.func_238421_b_(matrixStack, string, f, f2, n);
        RenderSystem.popMatrix();
    }

    private void drawPerkTooltip(MatrixStack matrixStack) {
        if (this.hoveredIcon != null) {
            this.hoveredPerkLevel = this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk);
            int levelWithBonus = this.cap.getPerkLevelWithBonus((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.hoveredIcon.perk.getTranslation());
            ITextComponent specialInfo = this.hoveredIcon.perk.getSpecialInfo(levelWithBonus);
            if (specialInfo != StringTextComponent.field_240750_d_) {
                list.add(specialInfo);
            }
            IntStream.rangeClosed(1, this.hoveredIcon.perk.getLevelMax()).forEach(i -> {
                ITextComponent info = this.hoveredIcon.perk.getTooltip(i, this.hoveredPerkLevel, levelWithBonus);
                if (info != StringTextComponent.field_240750_d_) {
                    TextFormatting formatting = this.hoveredPerkLevel >= i ? TextFormatting.WHITE : ((this.hoveredIcon.perk.isEncrypted() ? levelWithBonus >= i : levelWithBonus == i) ? TextFormatting.DARK_PURPLE : TextFormatting.DARK_GRAY);
                    boolean isEncrypted = this.hoveredIcon.perk.isEncrypted() && levelWithBonus < i - 1;
                    list.add(new StringTextComponent(i + " -> ").func_230529_a_((ITextComponent)(isEncrypted ? info.func_230531_f_().func_230530_a_(StyleType.STANDARD_GALACTIC) : info)).func_240699_a_(formatting));
                }
            });
            if (this.hoveredPerkLevel < this.hoveredIcon.perk.getLevelMax()) {
                int cost = this.hoveredIcon.perk.getCost(this.hoveredPerkLevel + 1);
                boolean canUpgrade = this.leftPerkPoints >= cost;
                list.add(LangKey.MESSAGE_COST.getText(canUpgrade ? TextFormatting.AQUA : TextFormatting.RED, new Object[]{cost}));
                list.add(canUpgrade ? LangKey.MESSAGE_CLICK_TO_UPGRADE.getText(TextFormatting.BLUE, new Object[0]) : LangKey.MESSAGE_CANT_UPGRADE.getText(TextFormatting.RED, new Object[0]));
            } else {
                list.add(LangKey.MESSAGE_MAX.getText(TextFormatting.GOLD, new Object[0]));
            }
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, list, (int)(this.hoveredIcon.minX + 10), (int)(this.hoveredIcon.minY + 10), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)200, (FontRenderer)this.field_230712_o_);
        }
    }

    public class PerkIcon {
        public final Perk perk;
        int minX;
        int minY;
        int maxX;
        int maxY;

        PerkIcon(Perk perk) {
            this.perk = perk;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        boolean contains(double x, double y) {
            return x >= (double)this.minX && y >= (double)this.minY && x <= (double)this.maxX && y <= (double)(this.maxY + 10);
        }

        int getMinX() {
            return this.minX;
        }

        int getMinY() {
            return this.minY;
        }

        int getMaxX() {
            return this.maxX;
        }

        int getMaxY() {
            return this.maxY;
        }
    }
}

