/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;

public class LootHelper {
    private static void addEntry(LootPool.Builder builder, Item item, int weight, Consumer<CompoundNBT> consumer) {
        builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_216085_b(-2).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)((CompoundNBT)Util.func_200696_a((Object)new CompoundNBT(), consumer)))));
    }

    private static void addEnchantedEntry(LootPool.Builder builder, Item item, int weight) {
        LootHelper.addEntry(builder, item, weight, nbt -> nbt.func_74757_a("enchant", true));
    }

    private static void addAncientTablet(LootPool.Builder builder, ItemTablet item) {
        LootHelper.addEntry(builder, item, 3, nbt -> {
            nbt.func_74757_a("enchant", true);
            nbt.func_74757_a("ancient", true);
        });
    }

    public static void addLostEntries(LootTable table) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:lost_treasure");
        builder.func_212840_b_(InOpenWaterCondition.builder());
        boolean valid = false;
        if (ModItems.tablet_of_recall.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_recall);
            valid = true;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_home);
            valid = true;
        }
        int lostTabletChance = (Integer)SharedConfigTombstone.loot.chanceLootLostTablet.get();
        if (ModItems.lost_tablet.isEnabled() && lostTabletChance > 0) {
            builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.lost_tablet).func_216085_b(-2).func_216086_a(lostTabletChance));
            valid = true;
        }
        if (valid) {
            if (lostTabletChance < 1000) {
                builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216085_b(-2).func_216086_a(1000 - lostTabletChance));
            }
            table.addPool(builder.func_216044_b());
        }
    }

    public static void addChestEntries(LootTable table) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:chest_treasure");
        int weight = 0;
        for (ItemScrollBuff scroll : ModItems.scroll_buff) {
            if (!scroll.isEnabled()) continue;
            LootHelper.addEnchantedEntry(builder, scroll, 1);
            ++weight;
        }
        if (ModItems.scroll_of_knowledge.isEnabled()) {
            LootHelper.addEntry(builder, ModItems.scroll_of_knowledge, 1, nbt -> nbt.func_74768_a("stored_xp", 2000));
            ++weight;
        }
        if (ModItems.tablet_of_cupidity.isEnabled()) {
            LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_cupidity, 1);
            ++weight;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_home, 1);
            ++weight;
        }
        if (weight == 0) {
            return;
        }
        builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(100 - weight));
        table.addPool(builder.func_216044_b());
    }

    public static void handleMobDrops(Collection<ItemEntity> drops, LivingEntity entity, @Nullable DamageSource damageSource) {
        ServerPlayerEntity player;
        ServerPlayerEntity serverPlayerEntity = player = damageSource != null && EntityHelper.isValidPlayerMP(damageSource.func_76346_g()) ? (ServerPlayerEntity)damageSource.func_76346_g() : null;
        if (player == null) {
            return;
        }
        Random rng = player.func_70681_au();
        if (entity.func_70662_br()) {
            float boneCollectorBonus = (float)EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.bone_collector) * 0.01f;
            float chanceGraveDust = (float)((Integer)ConfigTombstone.loot.chanceGraveDust.get()).intValue() * 0.001f + boneCollectorBonus;
            if (chanceGraveDust >= 1.0f || rng.nextFloat() <= chanceGraveDust) {
                LootHelper.addDropToEntity(drops, entity, new ItemStack((IItemProvider)ModItems.grave_dust, rng.nextBoolean() ? 1 : 2));
            }
            if (((Boolean)ConfigTombstone.loot.undeadCanDropSkull.get()).booleanValue() && rng.nextFloat() <= 0.005f) {
                ItemStack skullStack = new ItemStack((IItemProvider)(entity instanceof ZombieEntity ? Items.field_196186_dz : Items.field_196182_dv));
                LootHelper.addDropToEntity(drops, entity, skullStack);
            }
            if (!entity.func_184222_aU()) {
                float chanceDecorativeGraveOnBoss;
                ItemScrollBuff scroll;
                float chanceRandomScrollOnBoss;
                float chanceSoulReceptacleOnBoss = (float)((Integer)ConfigTombstone.loot.chanceSoulReceptacleOnBoss.get()).intValue() * 0.001f + boneCollectorBonus;
                if (chanceSoulReceptacleOnBoss >= 1.0f || rng.nextFloat() <= chanceSoulReceptacleOnBoss) {
                    LootHelper.addDropToEntity(drops, entity, new ItemStack((IItemProvider)ModItems.soul_receptacle));
                }
                if (((chanceRandomScrollOnBoss = (float)((Integer)ConfigTombstone.loot.chanceRandomScrollOnBoss.get()).intValue() * 0.001f + boneCollectorBonus) >= 1.0f || rng.nextFloat() <= chanceRandomScrollOnBoss) && (scroll = ModItems.scroll_buff[ItemScrollBuff.SpellBuff.getRandomBuff().ordinal()]).isEnabled()) {
                    LootHelper.addDropToEntity(drops, entity, NBTStackHelper.setBoolean(new ItemStack((IItemProvider)scroll), "enchant", true));
                }
                float chanceRandomPoppetOnBoss = (float)((Integer)ConfigTombstone.loot.chanceRandomPoppetOnBoss.get()).intValue() * 0.001f + boneCollectorBonus;
                if (ModItems.voodoo_poppet.isEnabled() && chanceRandomPoppetOnBoss >= 1.0f || rng.nextFloat() <= chanceRandomPoppetOnBoss) {
                    LootHelper.addDropToEntity(drops, entity, NBTStackHelper.setBoolean(ModItems.voodoo_poppet.addProtection(new ItemStack((IItemProvider)ModItems.voodoo_poppet), ItemVoodooPoppet.PoppetProtections.getRandomProtection()), "enchant", true));
                }
                if ((chanceDecorativeGraveOnBoss = (float)((Integer)ConfigTombstone.loot.chanceDecorativeGraveOnBoss.get()).intValue() * 0.001f + boneCollectorBonus) >= 1.0f || rng.nextFloat() <= chanceDecorativeGraveOnBoss) {
                    LootHelper.addDropToEntity(drops, entity, ItemBlockGrave.createRandomDecorativeStack());
                }
            }
        }
        if ((Helper.isContributor((PlayerEntity)player) || Helper.isDateAroundHalloween()) && entity instanceof MonsterEntity && rng.nextFloat() <= 0.1f) {
            LootHelper.addDropToEntity(drops, entity, new ItemStack((IItemProvider)ModItems.lollipop[player.field_70170_p.field_73012_v.nextInt(ModItems.lollipop.length)]));
        }
    }

    private static void addDropToEntity(Collection<ItemEntity> drops, LivingEntity entity, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            drops.add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack));
        }
    }
}

