/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.ResourceLocation;

public class StatelessTrigger
implements ICriterionTrigger<Instance> {
    private final ResourceLocation rl;
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public StatelessTrigger(String name) {
        this.rl = new ResourceLocation("tombstone", name);
    }

    public StatelessTrigger(ResourceLocation rl) {
        this.rl = rl;
    }

    public ResourceLocation func_192163_a() {
        return this.rl;
    }

    public void func_192165_a(PlayerAdvancements advancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.computeIfAbsent(advancements, Listeners::new);
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements advancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(advancements);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            this.listeners.remove(advancements);
        }
    }

    public void func_192167_a(PlayerAdvancements advancements) {
        this.listeners.remove(advancements);
    }

    public Instance deserialize(JsonObject object, ConditionArrayParser conditions) {
        return new Instance(this.rl);
    }

    public void trigger(ServerPlayerEntity player) {
        Listeners listener = this.listeners.get(player.func_192039_O());
        if (listener != null) {
            listener.trigger();
        }
    }

    static class Listeners {
        private final PlayerAdvancements advancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        public Listeners(PlayerAdvancements advancements) {
            this.advancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger() {
            new ArrayList<ICriterionTrigger.Listener<Instance>>(this.listeners).forEach((Consumer<ICriterionTrigger.Listener<Instance>>)((Consumer<ICriterionTrigger.Listener>)listener -> listener.func_192159_a(this.advancements)));
        }
    }

    public static class Instance
    extends CriterionInstance {
        Instance(ResourceLocation identifier) {
            super(identifier, EntityPredicate.AndPredicate.field_234582_a_);
        }
    }
}

