/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.LinkedList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class TeleportationHandler {
    public static Entity teleportEntity(Entity entity, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord) {
        return TeleportationHandler.teleportEntity(entity, targetWorld, xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
    }

    public static Entity teleportEntity(Entity entity, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        MinecraftServer server;
        if (!entity.field_70170_p.field_72995_K && entity.func_70089_S() && (server = entity.func_184102_h()) != null) {
            ServerWorld sourceWorld = (ServerWorld)entity.field_70170_p;
            if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
                return TeleportationHandler.teleportEntity(entity, server, sourceWorld, targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
            }
            Entity lowestRidingEntity = entity.func_184208_bv();
            PassengerHelper passengerHelper = new PassengerHelper(lowestRidingEntity);
            PassengerHelper rider = passengerHelper.getPassenger(entity);
            if (rider == null) {
                return entity;
            }
            passengerHelper.teleport(server, sourceWorld, targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
            passengerHelper.remountRiders();
            passengerHelper.updateClients();
            return rider.entity;
        }
        return entity;
    }

    private static Entity teleportEntity(Entity entity, MinecraftServer server, ServerWorld sourceWorld, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || !entity.func_70089_S()) {
            return entity;
        }
        boolean interDimensional = !sourceWorld.func_234923_W_().equals(targetWorld.func_234923_W_());
        boolean isPlayer = entity instanceof ServerPlayerEntity;
        if (interDimensional) {
            if (ForgeHooks.onTravelToDimension((Entity)entity, (RegistryKey)targetWorld.func_234923_W_())) {
                if (isPlayer) {
                    return TeleportationHandler.teleportPlayerInterdimensional((ServerPlayerEntity)entity, server, targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
                }
                return TeleportationHandler.teleportEntityInterdimensional(entity, sourceWorld, targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
            }
        } else if (isPlayer) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
            player.func_70034_d(yaw);
        } else {
            entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            entity.func_70034_d(yaw);
        }
        return entity;
    }

    private static ServerPlayerEntity teleportPlayerInterdimensional(ServerPlayerEntity player, MinecraftServer server, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        UUID id = player.func_110124_au();
        player.func_200619_a(targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
        return server.func_184103_al().func_177451_a(id);
    }

    private static Entity teleportEntityInterdimensional(Entity entity, ServerWorld sourceWorld, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        Vector3d motion = entity.func_213322_ci();
        entity.func_213319_R();
        Entity newEntity = entity.func_200600_R().func_200721_a((World)targetWorld);
        if (newEntity != null) {
            CompoundNBT nbt = new CompoundNBT();
            entity.func_184198_c(nbt);
            nbt.func_82580_o("Dimension");
            newEntity.func_70020_e(nbt);
            newEntity.field_242273_aw = entity.field_242273_aw;
            newEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            newEntity.func_213317_d(motion);
            targetWorld.func_217460_e(newEntity);
            sourceWorld.func_82742_i();
            targetWorld.func_82742_i();
        }
        entity.remove(false);
        return newEntity;
    }

    private static class PassengerHelper {
        public Entity entity;
        final LinkedList<PassengerHelper> passengers = new LinkedList();
        double offsetX;
        double offsetY;
        double offsetZ;

        PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                this.offsetX = entity.func_226277_ct_() - entity.func_184187_bx().func_226277_ct_();
                this.offsetY = entity.func_226278_cu_() - entity.func_184187_bx().func_226278_cu_();
                this.offsetZ = entity.func_226281_cx_() - entity.func_184187_bx().func_226281_cx_();
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        void teleport(MinecraftServer server, ServerWorld sourceWorld, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.func_184226_ay();
            this.entity = TeleportationHandler.teleportEntity(this.entity, server, sourceWorld, targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceWorld, targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
            }
        }

        void remountRiders() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.func_226277_ct_() + this.offsetX, this.entity.func_226278_cu_() + this.offsetY, this.entity.func_226281_cx_() + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        void updateClients() {
            if (this.entity instanceof ServerPlayerEntity) {
                this.updateClient((ServerPlayerEntity)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayerEntity playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

