/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfDisenchantment
extends ItemGeneric
implements ISoulConsumer {
    public ItemBookOfDisenchantment() {
        super("book_of_disenchantment", ItemBookOfDisenchantment.getBuilder(true), () -> SharedConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            this.addItemUse(list);
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        return this.isEnabled();
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stackPar) {
        ResourceLocation registryName;
        if (stackPar.func_77973_b() != this) {
            return false;
        }
        ItemStack offhand = player.func_184592_cb();
        if (offhand.func_190926_b() || offhand.func_77973_b() == Items.field_151134_bR || !offhand.func_77948_v()) {
            return false;
        }
        if (SupportMods.TETRA.isLoaded() && ((Boolean)ConfigTombstone.compatibility.disableDisenchantmentForTetra.get()).booleanValue() && (registryName = offhand.func_77973_b().getRegistryName()) != null && registryName.func_110624_b().equals(SupportMods.TETRA.func_176610_l()) && registryName.func_110623_a().startsWith("modular_")) {
            return false;
        }
        Map list = EnchantmentHelper.func_82781_a((ItemStack)offhand);
        if (list.size() == 0) {
            return false;
        }
        Iterator it = list.entrySet().iterator();
        stackPar.func_190918_g(1);
        int enchantMax = EntityHelper.getPerkLevelWithBonus(player, ModPerks.disenchanter) + 1;
        int enchantCount = 0;
        while (enchantCount < enchantMax && it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
            HashMap map = new HashMap();
            map.put(entry.getKey(), entry.getValue());
            EnchantmentHelper.func_82782_a(map, (ItemStack)book);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)book);
            it.remove();
            ++enchantCount;
        }
        if (list.isEmpty()) {
            offhand.func_196082_o().func_82580_o("RepairCost");
        }
        EnchantmentHelper.func_82782_a((Map)list, (ItemStack)offhand);
        if (!world.field_72995_K) {
            ModTriggers.USE_DISENCHANTMENT.trigger((ServerPlayerEntity)player);
        }
        return true;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_DISENCHANTMENT_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

