/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollOfKnowledge
extends ItemScroll {
    public ItemScrollOfKnowledge() {
        super("scroll_of_knowledge", () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfKnowledge.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            if (!this.isEnchanted(stack)) {
                this.addItemDesc(list, "1", new Object[0]);
                this.addItemUse(list, "1", new Object[0]);
            } else {
                this.addItemDesc(list, "2", new Object[0]);
                this.addInfo(list, LangKey.MESSAGE_STORED_EXPERIENCE, this.getStoredXp(stack));
                this.addItemUse(list, "2", new Object[0]);
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.getStoredXp(stack) > 0;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_LOSE_EXPERIENCE_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_LOSE_EXPERIENCE_FAILED.getText(new Object[0]);
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        boolean valid = this.setStoredXp(stack, EntityHelper.getPlayerTotalXp(player));
        if (valid) {
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
            player.field_71106_cc = 0.0f;
        }
        return valid;
    }

    @Override
    protected boolean doEffects(World world, ServerPlayerEntity player, ItemStack stack) {
        int i;
        int storedXp = this.getStoredXp(stack);
        if (storedXp > (i = Integer.MAX_VALUE - player.field_71067_cb)) {
            LangKey.MESSAGE_EARN_EXPERIENCE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        EntityHelper.setPlayerXp((PlayerEntity)player, EntityHelper.getPlayerTotalXp((PlayerEntity)player) + storedXp);
        LangKey.MESSAGE_EARN_EXPERIENCE_SUCCESS.sendMessage((PlayerEntity)player, new Object[0]);
        ModTriggers.USE_KNOWLEDGE.trigger(player);
        return true;
    }

    public int getStoredXp(ItemStack stack) {
        int storedXp = NBTStackHelper.getInteger(stack, "stored_xp");
        return storedXp > 0 ? storedXp : 0;
    }

    public boolean setStoredXp(ItemStack stack, int xp) {
        if (stack.func_77973_b() != this || xp <= 0) {
            return false;
        }
        NBTStackHelper.setInteger(stack, "stored_xp", xp);
        return true;
    }
}

