/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfRecall
extends ItemTablet {
    public ItemTabletOfRecall() {
        super("tablet_of_recall", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfRecall.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            boolean isAncient = this.isAncient(stack);
            if (isAncient) {
                this.addItemDesc(list, "_ancient", new Object[0]);
            }
            if (!this.isEnchanted(stack)) {
                this.addItemUse(list, "1", new Object[0]);
            } else {
                Location location = this.getTombPos(stack);
                if (!location.isOrigin()) {
                    this.addItemPosition(list, location);
                    this.addItemUse(list, "2", new Object[0]);
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
            if (isAncient) {
                this.addInfoInBeta(list);
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    private boolean setTombPos(ItemStack stack, Location location) {
        if (stack.func_77973_b() != this || location.isOrigin()) {
            return false;
        }
        NBTStackHelper.setLocation(stack, "tombPos", location);
        return true;
    }

    public Location getTombPos(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return Location.ORIGIN;
        }
        return NBTStackHelper.getLocation(stack, "tombPos");
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return !this.getTombPos(stack).isOrigin();
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        boolean valid = this.setTombPos(stack, new Location(gravePos, world));
        if (valid) {
            this.setUseCount(stack, this.getUseMax());
        }
        return valid;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getText(new Object[0]);
    }

    @Override
    public void onSneakGrave(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        if (!world.field_72995_K && this.isEnchanted(stack) && TimeHelper.atInterval(player.field_70173_aa, 20)) {
            this.setTombPos(stack, new Location(gravePos, world));
            player.func_184811_cZ().func_185145_a((Item)this, 100);
            player.func_145747_a((ITextComponent)this.getEnchantSuccessMessage(player).func_230531_f_().func_230530_a_(StyleType.MESSAGE_NORMAL), Util.field_240973_b_);
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!player.func_225608_bj_()) {
            return super.func_77659_a(world, player, hand);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    protected boolean doEffects(World world, ServerPlayerEntity player, ItemStack stack) {
        Location location = this.getTombPos(stack);
        boolean isSameDim = location.isSameDimension(world);
        if (isSameDim && location.isInRange(player.func_233580_cy_(), 10)) {
            LangKey.MESSAGE_TELEPORT_TOO_CLOSE_FROM_GRAVE.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        if (!isSameDim && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        CallbackHandler.addCallback(1, () -> {
            boolean isAncient = this.isAncient(stack);
            AxisAlignedBB area = isAncient ? player.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0) : null;
            ServerPlayerEntity newPlayer = Helper.teleportEntity(player, new Location(location.getPos().func_177984_a(), location.dim));
            if (isAncient) {
                List entities = world.func_72839_b((Entity)player, area);
                entities.forEach(entity -> Helper.teleportEntity(entity, new Location((Entity)newPlayer)));
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)newPlayer, new Object[0]);
            ModTriggers.USE_RECALL.trigger(player);
        });
        return true;
    }
}

