/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModItems;

public class RecipeFamiliarReceptacle
extends ShapedRecipe {
    private boolean setTag = false;

    public RecipeFamiliarReceptacle(ResourceLocation rl) {
        this(rl, 3, 3, RecipeFamiliarReceptacle.getIngredientList());
    }

    private static NonNullList<Ingredient> getIngredientList() {
        Ingredient tear = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151073_bk)});
        Ingredient iron = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j});
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{tear, iron, tear, iron, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.impregnated_diamond)}), iron, tear, iron, tear});
    }

    public RecipeFamiliarReceptacle(ResourceLocation rl, int width, int height, NonNullList<Ingredient> ingredients) {
        super(rl, "familiar_receptacle", width, height, ingredients, new ItemStack((IItemProvider)ModItems.familiar_receptacle));
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        if (!this.setTag) {
            Ingredient ironTag = Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_IRON);
            NonNullList ing = this.func_192400_c();
            ItemStack ironStack = new ItemStack((IItemProvider)Items.field_151042_j);
            IntStream.range(0, this.func_192400_c().size()).filter(i -> ((Ingredient)ing.get(i)).test(ironStack)).forEach(i -> {
                Ingredient cfr_ignored_0 = (Ingredient)ing.set(i, (Object)ironTag);
            });
            this.setTag = true;
        }
        return super.func_77569_a(inv, world);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        PlayerEntity player = RecipeFamiliarReceptacle.getPlayer(inv);
        return player == null ? ItemStack.field_190927_a : player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> cap.getTotalPerkPoints() >= (Integer)SharedConfigTombstone.general.familiarReceptacleRequiredLevel.get() ? this.getFinalResult(player, inv) : ItemStack.field_190927_a).orElse(ItemStack.field_190927_a);
    }

    private ItemStack getFinalResult(PlayerEntity player, CraftingInventory inv) {
        String impregnatedType = "";
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != ModItems.impregnated_diamond) continue;
            impregnatedType = ModItems.impregnated_diamond.getEntityType(stack);
            break;
        }
        return Helper.isTameable(player.field_70170_p, impregnatedType) ? ModItems.familiar_receptacle.setCapturableType(this.func_77571_b().func_77946_l(), impregnatedType) : this.func_77571_b().func_77946_l();
    }

    @Nullable
    private static PlayerEntity getPlayer(CraftingInventory inventory) {
        return inventory.field_70465_c.field_75151_b.stream().map(slot -> slot.field_75224_c).filter(PlayerInventory.class::isInstance).map(PlayerInventory.class::cast).map(inv -> inv.field_70458_d).findFirst().orElse(null);
    }
}

