/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;

public class RecipeVoodooPoppetProtection
extends ShapelessRecipe {
    private static final NonNullList<Ingredient> INGREDIENTS = NonNullList.func_191196_a();

    public RecipeVoodooPoppetProtection(ResourceLocation rl) {
        super(rl, "voodoo_poppet_protection", new ItemStack((IItemProvider)ModItems.voodoo_poppet), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{(Ingredient)INGREDIENTS.get(0), (Ingredient)INGREDIENTS.get(1), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221816_dr, Items.field_151064_bs, Items.field_151055_y, Items.field_151008_G, Items.field_151170_bI})}));
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        if (!ModItems.voodoo_poppet.isEnabled()) {
            return false;
        }
        boolean voodooPoppetFound = false;
        boolean dustFound = false;
        boolean compoFound = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (!voodooPoppetFound && stack.func_77973_b() == ModItems.voodoo_poppet && !ModItems.voodoo_poppet.isEnchanted(stack)) {
                voodooPoppetFound = true;
                continue;
            }
            if (!dustFound && ((Ingredient)INGREDIENTS.get(1)).test(stack)) {
                dustFound = true;
                continue;
            }
            if (!compoFound && ModTags.Items.VOODOO_POPPET_INGREDIENTS.func_230235_a_((Object)stack.func_77973_b())) {
                compoFound = true;
                continue;
            }
            return false;
        }
        return voodooPoppetFound && dustFound && compoFound;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack poppet = ItemStack.field_190927_a;
        ItemStack compo = ItemStack.field_190927_a;
        Enum prot = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (poppet.func_190926_b() && stack.func_77973_b() == ModItems.voodoo_poppet) {
                poppet = stack;
                continue;
            }
            if (!compo.func_190926_b() || !ModTags.Items.VOODOO_POPPET_INGREDIENTS.func_230235_a_((Object)stack.func_77973_b())) continue;
            prot = this.getPoppetProtection(stack);
        }
        if (poppet.func_190926_b() || prot == null || ModItems.voodoo_poppet.hasProtection(poppet, (ItemVoodooPoppet.PoppetProtections)prot)) {
            return ItemStack.field_190927_a;
        }
        if (EntityHelper.getPerkLevelWithBonus(RecipeVoodooPoppetProtection.getPlayer(inv), ModPerks.voodoo_poppet) > prot.ordinal()) {
            return ModItems.voodoo_poppet.addProtection(poppet.func_77946_l(), (ItemVoodooPoppet.PoppetProtections)prot);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    private ItemVoodooPoppet.PoppetProtections getPoppetProtection(ItemStack stack) {
        if (stack.func_77973_b() == Blocks.field_196651_dG.func_199767_j()) {
            return ItemVoodooPoppet.PoppetProtections.SUFFOCATION;
        }
        if (stack.func_77973_b() == Items.field_151064_bs) {
            return ItemVoodooPoppet.PoppetProtections.BURN;
        }
        if (stack.func_77973_b() == Items.field_151055_y) {
            return ItemVoodooPoppet.PoppetProtections.LIGHTNING;
        }
        if (stack.func_77973_b() == Items.field_151008_G) {
            return ItemVoodooPoppet.PoppetProtections.FALL;
        }
        if (stack.func_77973_b() == Items.field_151170_bI) {
            return ItemVoodooPoppet.PoppetProtections.DEGENERATION;
        }
        return null;
    }

    @Nullable
    private static PlayerEntity getPlayer(CraftingInventory inventory) {
        return inventory.field_70465_c.field_75151_b.stream().map(slot -> slot.field_75224_c).filter(PlayerInventory.class::isInstance).map(PlayerInventory.class::cast).map(inv -> inv.field_70458_d).findFirst().orElse(null);
    }

    static {
        INGREDIENTS.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.voodoo_poppet)}));
        INGREDIENTS.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.grave_dust)}));
    }
}

