/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@OnlyIn(value=Dist.CLIENT)
public class RenderWritableGrave<T extends TileEntityWritableGrave>
extends TileEntityRenderer<T> {
    private static final ResourceLocation TEXTURE_SKELETON_HEAD = new ResourceLocation("minecraft", "textures/entity/skeleton/skeleton.png");

    public RenderWritableGrave(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int light, int destroyStage) {
        int rotationIndex;
        float modY;
        float value;
        boolean renderHalloween;
        if (te == null || te.func_145831_w() == null) {
            return;
        }
        boolean bl = renderHalloween = ConfigTombstone.client.graveSkinRule.get() == ConfigTombstone.Client.GraveSkinRule.FORCE_HALLOWEEN || Helper.isDateAroundHalloween() && ConfigTombstone.client.graveSkinRule.get() != ConfigTombstone.Client.GraveSkinRule.FORCE_NORMAL;
        if (!((TileEntityWritableGrave)((Object)te)).hasOwner() && !renderHalloween) {
            return;
        }
        BlockState knownState = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (!(knownState.func_177230_c() instanceof BlockGraveBase)) {
            return;
        }
        Direction facing = (Direction)knownState.func_177229_b((Property)BlockGraveBase.FACING);
        BlockGraveBase grave = (BlockGraveBase)knownState.func_177230_c();
        GraveModel graveModel = grave.getGraveType();
        if (renderHalloween) {
            this.renderHalloween(matrixStack, iRenderTypeBuffer, graveModel, facing, light, Helper.isNight(te.func_145831_w()));
        }
        light = 0xF000F0;
        if (!((TileEntityWritableGrave)((Object)te)).hasOwner()) {
            return;
        }
        float modX = 0.5f;
        float modZ = 0.5f;
        switch (graveModel) {
            case GRAVE_CROSS: {
                value = 0.25f;
                modY = 0.06375f;
                break;
            }
            case GRAVE_NORMAL: {
                value = 0.12625f;
                modY = 0.5f;
                break;
            }
            case TOMBSTONE: {
                value = 0.56375f;
                modY = 0.25f;
                break;
            }
            case SUBARAKI_GRAVE: {
                value = 0.64f;
                modY = 0.65f;
                break;
            }
            case GRAVE_ORIGINAL: {
                value = 0.99f;
                modY = 0.2f;
                break;
            }
            default: {
                value = 0.18875f;
                modY = 0.4f;
            }
        }
        boolean is_cross = graveModel == GraveModel.GRAVE_CROSS;
        boolean is_original = graveModel == GraveModel.GRAVE_ORIGINAL;
        switch (facing) {
            case SOUTH: {
                rotationIndex = 0;
                if (is_cross) {
                    modZ = 1.0f - value;
                    break;
                }
                modZ = value;
                break;
            }
            case WEST: {
                rotationIndex = -1;
                if (is_cross) {
                    modX = value;
                    break;
                }
                modX = 1.0f - value;
                break;
            }
            case EAST: {
                rotationIndex = 1;
                if (is_cross) {
                    modX = 1.0f - value;
                    break;
                }
                modX = value;
                break;
            }
            default: {
                rotationIndex = 2;
                modZ = is_cross ? value : 1.0f - value;
            }
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)modX, (double)modY, (double)modZ);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        if (is_cross) {
            switch (facing) {
                case SOUTH: {
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                    break;
                }
                case WEST: {
                    matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                    break;
                }
                case EAST: {
                    matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
                    break;
                }
                default: {
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                }
            }
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f * (float)rotationIndex));
        FontRenderer fontRender = this.field_228858_b_.field_147557_n;
        this.showString(TextFormatting.BOLD + LangKey.MESSAGE_RIP.getClientTranslation(new Object[0]), matrixStack, iRenderTypeBuffer, fontRender, is_original ? 8 : 0, (Integer)ConfigTombstone.client.textColorRIP.get() + -16777216, 0.007f, light);
        this.showString(TextFormatting.BOLD + ((TileEntityWritableGrave)((Object)te)).getOwnerName(), matrixStack, iRenderTypeBuffer, fontRender, is_original ? 14 : 11, (Integer)ConfigTombstone.client.textColorOwner.get() + -16777216, 0.005f, light);
        float scaleForDate = (Boolean)ConfigTombstone.client.dateInMCTime.get() != false ? 0.005f : 0.004f;
        this.showString(TextFormatting.BOLD + LangKey.MESSAGE_DIED_ON.getClientTranslation(new Object[0]), matrixStack, iRenderTypeBuffer, fontRender, 26, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, light);
        if (((Boolean)ConfigTombstone.client.dateInMCTime.get()).booleanValue()) {
            long days = ((TileEntityWritableGrave)((Object)te)).countTicks / 24000;
            String dateString = LangKey.MESSAGE_DAY.getClientTranslation(days);
            this.showString(TextFormatting.BOLD + dateString, matrixStack, iRenderTypeBuffer, fontRender, 36, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, light);
        } else {
            Date date = new Date(((TileEntityWritableGrave)((Object)te)).getOwnerDeathTime());
            String dateString = new SimpleDateFormat("dd/MM/yyyy").format(date);
            String timeString = LangKey.MESSAGE_AT.getClientTranslation(new Object[0]) + " " + new SimpleDateFormat("HH:mm:ss").format(date);
            this.showString(TextFormatting.BOLD + dateString, matrixStack, iRenderTypeBuffer, fontRender, 36, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, light);
            this.showString(TextFormatting.BOLD + timeString, matrixStack, iRenderTypeBuffer, fontRender, 46, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate, light);
        }
        matrixStack.func_227865_b_();
    }

    private void showString(String content, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, FontRenderer fontRenderer, int posY, int color, float scale, int light) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, scale);
        fontRenderer.func_228079_a_(content, (float)(-fontRenderer.func_78256_a(content) / 2), (float)(posY - 30), color, false, matrixStack.func_227866_c_().func_227870_a_(), iRenderTypeBuffer, false, 0, light);
        matrixStack.func_227865_b_();
    }

    private void renderHalloween(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, GraveModel graveModel, Direction facing, int light, boolean isNight) {
        RenderSystem.enableRescaleNormal();
        RenderSystem.pushMatrix();
        RenderSystem.disableCull();
        RenderSystem.enableAlphaTest();
        float decoX = 0.5f;
        float decoY = 0.07f;
        float decoZ = 0.5f;
        switch (graveModel) {
            case GRAVE_NORMAL: {
                decoY += 0.35f;
                break;
            }
            case GRAVE_CROSS: {
                if (facing == Direction.SOUTH) {
                    decoX -= 0.2f;
                    break;
                }
                if (facing == Direction.WEST) {
                    decoZ -= 0.2f;
                    break;
                }
                if (facing == Direction.EAST) {
                    decoZ += 0.2f;
                    break;
                }
                decoX += 0.2f;
                break;
            }
            case TOMBSTONE: {
                decoY += 0.6f;
                break;
            }
            case SUBARAKI_GRAVE: {
                decoY += 0.37f;
                if (facing == Direction.SOUTH) {
                    decoX += 0.35f;
                    decoZ += 0.35f;
                    break;
                }
                if (facing == Direction.WEST) {
                    decoX -= 0.35f;
                    decoZ += 0.35f;
                    break;
                }
                if (facing == Direction.EAST) {
                    decoX += 0.35f;
                    decoZ -= 0.35f;
                    break;
                }
                decoX -= 0.35f;
                decoZ -= 0.35f;
                break;
            }
            case GRAVE_ORIGINAL: {
                if (facing == Direction.SOUTH) {
                    decoZ += 0.35f;
                    decoX += 0.575f;
                    break;
                }
                if (facing == Direction.WEST) {
                    decoZ += 0.575f;
                    decoX -= 0.35f;
                    break;
                }
                if (facing == Direction.EAST) {
                    decoZ -= 0.575f;
                    decoX += 0.35f;
                    break;
                }
                decoZ -= 0.35f;
                decoX -= 0.575f;
                break;
            }
            default: {
                decoY += 0.1f;
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_SKELETON_HEAD);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)decoX, (double)decoY, (double)decoZ);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(facing.func_185119_l() + (float)(facing == Direction.SOUTH || facing == Direction.NORTH ? 180 : 0)));
        if (graveModel == GraveModel.GRAVE_NORMAL || graveModel == GraveModel.GRAVE_SIMPLE) {
            matrixStack.func_227862_a_(0.2f, 0.2f, 0.2f);
            ItemStack stack = new ItemStack((IItemProvider)(isNight ? Blocks.field_196628_cT : Blocks.field_150423_aK));
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, matrixStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.field_229196_a_, Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null));
        } else {
            matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
            SkullTileEntityRenderer.func_228879_a_(null, (float)1.0f, (SkullBlock.ISkullType)SkullBlock.Types.SKELETON, null, (float)0.0f, (MatrixStack)matrixStack, (IRenderTypeBuffer)iRenderTypeBuffer, (int)(isNight ? 0xF000F0 : light));
        }
        matrixStack.func_227865_b_();
        RenderSystem.popMatrix();
    }
}

