/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityDecorativeGrave
extends TileEntityWritableGrave {
    private long lastCheckSoul = -1L;

    public TileEntityDecorativeGrave() {
        super(ModBlocks.tile_decorative_grave);
    }

    @Override
    public boolean canShowFog() {
        return this.field_145850_b != null && ((ConfigTombstone.Client.FogPeriod)ConfigTombstone.client.fogPeriod.get()).test(this.field_145850_b);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || !(this.func_195044_w().func_177230_c() instanceof BlockDecorativeGrave)) {
            return;
        }
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (TimeHelper.atInterval(this.countTicks, 100) && ((Boolean)this.func_195044_w().func_177229_b((Property)BlockDecorativeGrave.HAS_SOUL)).booleanValue()) {
                ModTombstone.PROXY.produceGraveSoul(this.field_145850_b, this.field_174879_c);
            }
        } else {
            long worldTicks = TimeHelper.worldTicks(this.field_145850_b);
            if (this.lastCheckSoul <= 0L || this.lastCheckSoul > worldTicks) {
                this.lastCheckSoul = worldTicks;
                return;
            }
            long elapsedMinutes = TimeHelper.minuteElapsed(this.field_145850_b, this.lastCheckSoul);
            if (elapsedMinutes >= (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue()) {
                if (((Boolean)this.func_195044_w().func_177229_b((Property)BlockDecorativeGrave.HAS_SOUL)).booleanValue()) {
                    this.resetCheckSoul();
                    return;
                }
                long count = elapsedMinutes / (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue();
                this.lastCheckSoul += count * (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue();
                double chance = 1.0 - Math.pow(1.0 - (double)((Integer)ConfigTombstone.decorative_grave.chanceSoul.get()).intValue() / 1000.0, count);
                if (chance >= 1.0 || this.field_145850_b.field_73012_v.nextDouble() <= chance) {
                    if (elapsedMinutes == (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue()) {
                        LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_145850_b);
                        lightning.func_233576_c_(Vector3d.func_237492_c_((Vector3i)this.field_174879_c));
                        lightning.func_233623_a_(true);
                        this.field_145850_b.func_217376_c((Entity)lightning);
                    }
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockDecorativeGrave.HAS_SOUL, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
        }
    }

    public void resetCheckSoul() {
        this.lastCheckSoul = -1L;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return super.func_189515_b(compound);
    }

    @Override
    protected CompoundNBT writeShared(CompoundNBT compound) {
        super.writeShared(compound);
        if (this.lastCheckSoul > 0L) {
            compound.func_74772_a("lastCheckSoul", this.lastCheckSoul);
        }
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("lastCheckSoul")) {
            this.lastCheckSoul = compound.func_74763_f("lastCheckSoul");
        }
    }
}

