/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.bars;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.torocraft.torohealth.ToroHealth;
import net.torocraft.torohealth.bars.BarState;
import net.torocraft.torohealth.bars.BarStates;
import net.torocraft.torohealth.config.Config;
import net.torocraft.torohealth.util.EntityUtil;

public class HealthBarRenderer {
    private static final class_2960 GUI_BARS_TEXTURES = new class_2960("torohealth:textures/gui/bars.png");
    private static final int DARK_GRAY = -2139062017;
    private static final float FULL_SIZE = 40.0f;

    private static Config.InWorld getConfig() {
        return ToroHealth.CONFIG.inWorld;
    }

    public static void renderInWorld(class_4587 matrix, class_1309 entity, class_4184 camera) {
        if (Config.Mode.NONE.equals((Object)HealthBarRenderer.getConfig().mode)) {
            return;
        }
        if (Config.Mode.WHEN_HOLDING_WEAPON.equals((Object)HealthBarRenderer.getConfig().mode) && !ToroHealth.IS_HOLDING_WEAPON) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == entity) {
            return;
        }
        if (camera == null) {
            camera = client.method_1561().field_4686;
        }
        if (camera == null) {
            return;
        }
        if (ToroHealth.CONFIG.inWorld.onlyWhenLookingAt && ToroHealth.HUD.getEntity() != entity) {
            return;
        }
        if (ToroHealth.CONFIG.inWorld.onlyWhenHurt && entity.method_6032() >= entity.method_6063()) {
            return;
        }
        if (entity.method_5739(client.method_1560()) > ToroHealth.CONFIG.inWorld.distance) {
            return;
        }
        float scaleToGui = 0.025f;
        boolean sneaking = entity.method_18276();
        float height = entity.method_17682() + 0.5f - (sneaking ? 0.25f : 0.0f);
        float tickDelta = client.method_1488();
        double x = class_3532.method_16436((double)tickDelta, (double)entity.field_6014, (double)entity.method_23317());
        double y = class_3532.method_16436((double)tickDelta, (double)entity.field_6036, (double)entity.method_23318());
        double z = class_3532.method_16436((double)tickDelta, (double)entity.field_5969, (double)entity.method_23321());
        class_243 camPos = camera.method_19326();
        double camX = camPos.field_1352;
        double camY = camPos.field_1351;
        double camZ = camPos.field_1350;
        matrix.method_22903();
        matrix.method_22904(x - camX, y + (double)height - camY, z - camZ);
        matrix.method_22907(class_1160.field_20705.method_23214(-camera.method_19330()));
        matrix.method_22907(class_1160.field_20703.method_23214(camera.method_19329()));
        matrix.method_22905(-scaleToGui, -scaleToGui, scaleToGui);
        RenderSystem.disableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        HealthBarRenderer.render(matrix, entity, 0.0, 0.0, 40.0f, true);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        matrix.method_22909();
    }

    public static void render(class_4587 matrix, class_1309 entity, double x, double y, float width, boolean inWorld) {
        EntityUtil.Relation relation = EntityUtil.determineRelation((class_1297)entity);
        int color = relation.equals((Object)EntityUtil.Relation.FRIEND) ? ToroHealth.CONFIG.bar.friendColor : ToroHealth.CONFIG.bar.foeColor;
        int color2 = relation.equals((Object)EntityUtil.Relation.FRIEND) ? ToroHealth.CONFIG.bar.friendColorSecondary : ToroHealth.CONFIG.bar.foeColorSecondary;
        BarState state = BarStates.getState(entity);
        float percent = Math.min(1.0f, entity.method_6032() / entity.method_6063());
        float percent2 = state.previousHealthDisplay / entity.method_6063();
        int zOffset = 0;
        class_1159 m4f = matrix.method_23760().method_23761();
        HealthBarRenderer.drawBar(m4f, x, y, width, 1.0f, -2139062017, zOffset++, inWorld);
        HealthBarRenderer.drawBar(m4f, x, y, width, percent2, color2, zOffset++, inWorld);
        HealthBarRenderer.drawBar(m4f, x, y, width, percent, color, zOffset, inWorld);
        if (!inWorld) {
            if (ToroHealth.CONFIG.bar.damageNumberType.equals((Object)Config.NumberType.CUMULATIVE)) {
                HealthBarRenderer.drawDamageNumber(matrix, state.previousHealth - entity.method_6032(), x, y, width);
            } else if (ToroHealth.CONFIG.bar.damageNumberType.equals((Object)Config.NumberType.LAST)) {
                HealthBarRenderer.drawDamageNumber(matrix, state.lastDmg, x, y, width);
            }
        }
    }

    public static void drawDamageNumber(class_4587 matrix, float dmg, double x, double y, float width) {
        int i = Math.abs(Math.round(dmg));
        if (i == 0) {
            return;
        }
        String s = Integer.toString(i);
        class_310 minecraft = class_310.method_1551();
        int sw = minecraft.field_1772.method_1727(s);
        int color = dmg < 0.0f ? ToroHealth.CONFIG.particle.healColor : ToroHealth.CONFIG.particle.damageColor;
        minecraft.field_1772.method_1729(matrix, s, (float)((int)(x + (double)(width / 2.0f) - (double)sw)), (float)((int)y + 5), color);
    }

    private static void drawBar(class_1159 matrix4f, double x, double y, float width, float percent, int color, int zOffset, boolean inWorld) {
        float c = 0.00390625f;
        int u = 0;
        int v = 65;
        int uw = class_3532.method_15386((float)(92.0f * percent));
        int vh = 5;
        double size = percent * width;
        double h = inWorld ? 4.0 : 6.0;
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        class_310.method_1551().method_1531().method_22813(GUI_BARS_TEXTURES);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        float half = width / 2.0f;
        float zOffsetAmount = inWorld ? -0.1f : 0.1f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(7, class_290.field_1585);
        buffer.method_22918(matrix4f, (float)((double)(-half) + x), (float)y, (float)zOffset * zOffsetAmount).method_22913((float)u * c, (float)v * c).method_1344();
        buffer.method_22918(matrix4f, (float)((double)(-half) + x), (float)(h + y), (float)zOffset * zOffsetAmount).method_22913((float)u * c, (float)(v + vh) * c).method_1344();
        buffer.method_22918(matrix4f, (float)((double)(-half) + size + x), (float)(h + y), (float)zOffset * zOffsetAmount).method_22913((float)(u + uw) * c, (float)(v + vh) * c).method_1344();
        buffer.method_22918(matrix4f, (float)((double)(-half) + size + x), (float)y, (float)zOffset * zOffsetAmount).method_22913((float)(u + uw) * c, (float)v * c).method_1344();
        tessellator.method_1350();
    }
}

