/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.travelers_index.client.pages;

import com._idrae.travelers_index.client.buttons.TextButton;
import com._idrae.travelers_index.client.gui.IndexScreen;
import com._idrae.travelers_index.client.pages.Page;
import java.util.ArrayList;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

@OnlyIn(value=Dist.CLIENT)
public class ModPage
extends Page {
    private static final int PAGE_MARGIN_Y = 39;
    private final ModInfo modInfo;
    public ArrayList<Item> items;
    public ArrayList<Item> itemItems;
    public ArrayList<Item> blockItems;
    public ArrayList<Item> checklist;
    public ArrayList<Item> checkedItemItems;
    public ArrayList<Item> checkedBlockItems;
    private TextButton blockButton;
    private TextButton itemButton;

    public ModPage(IndexScreen screen, ModInfo modInfo, ArrayList<Item> items, ArrayList<Item> checklist) {
        super(screen);
        this.modInfo = modInfo;
        this.items = items;
        this.checklist = checklist;
    }

    public void init() {
        this.computeCategoryLists();
        this.computeCategoryCounts();
        this.initBackButton(button -> this.discardAndShowTitlePage());
        this.blockButton = new TextButton(this.screen, this.screen.pageStartX + 18, this.screen.pageStartY + 39, this.screen.getStringWidth("Blocks"), "Blocks", this.checkedBlockItems.size() == this.blockItems.size() ? 16766720 : 0, button -> this.discardAndShowItemPage("block"));
        if (this.blockItems.size() > 0) {
            this.screen.addButton(this.blockButton);
        }
        this.itemButton = new TextButton(this.screen, this.screen.pageStartX + 18, this.blockItems.size() == 0 ? this.screen.pageStartY + 39 : this.screen.pageStartY + 39 + 9 + 6, this.screen.getStringWidth("Items"), "Items", this.checkedItemItems.size() == this.itemItems.size() ? 16766720 : 0, button -> this.discardAndShowItemPage("item"));
        if (this.itemItems.size() > 0) {
            this.screen.addButton(this.itemButton);
        }
    }

    private void computeCategoryLists() {
        this.itemItems = new ArrayList();
        this.blockItems = new ArrayList();
        for (Item item : this.items) {
            if (item instanceof BlockItem) {
                this.blockItems.add(item);
                continue;
            }
            this.itemItems.add(item);
        }
    }

    private void computeCategoryCounts() {
        this.checkedItemItems = new ArrayList();
        this.checkedBlockItems = new ArrayList();
        for (Item item : this.checklist) {
            if (item instanceof BlockItem) {
                this.checkedBlockItems.add(item);
                continue;
            }
            this.checkedItemItems.add(item);
        }
    }

    public void render() {
        this.drawCategoryCounts();
    }

    public void renderTooltips(int mouseX, int mouseY) {
        String blockCount = this.checkedBlockItems.size() + "/" + this.blockItems.size();
        String itemCount = this.checkedItemItems.size() + "/" + this.itemItems.size();
        boolean isBlockHovered = mouseX >= this.screen.pageStartX + 163 - 12 - this.screen.getStringWidth(blockCount) && mouseX < this.screen.pageStartX + 163 - 12 && mouseY >= this.screen.pageStartY + 39 && mouseY < this.screen.pageStartY + 39 + 9;
        int blockSize = this.blockItems.size() == 0 ? 1 : this.blockItems.size();
        int blockPercentage = this.checkedBlockItems.size() * 100 / blockSize;
        if (isBlockHovered && this.blockItems.size() > 0) {
            this.screen.renderTooltip(blockPercentage + "%", mouseX, mouseY);
        }
        boolean isItemHovered = this.blockItems.size() == 0 ? mouseX >= this.screen.pageStartX + 163 - 12 - this.screen.getStringWidth(itemCount) && mouseX < this.screen.pageStartX + 163 - 12 && mouseY >= this.screen.pageStartY + 39 && mouseY < this.screen.pageStartY + 39 + 9 : mouseX >= this.screen.pageStartX + 163 - 12 - this.screen.getStringWidth(itemCount) && mouseX < this.screen.pageStartX + 163 - 12 && mouseY >= this.screen.pageStartY + 39 + 9 + 6 && mouseY < this.screen.pageStartY + 39 + 9 + 6 + 9;
        int itemSize = this.itemItems.size() == 0 ? 1 : this.itemItems.size();
        int itemPercentage = this.checkedItemItems.size() * 100 / itemSize;
        if (isItemHovered && this.itemItems.size() > 0) {
            this.screen.renderTooltip(itemPercentage + "%", mouseX, mouseY);
        }
    }

    @Override
    public void clearButtons() {
        this.blockButton.visible = false;
        this.itemButton.visible = false;
        super.clearButtons();
    }

    private void drawCategoryCounts() {
        String blockCount = this.checkedBlockItems.size() + "/" + this.blockItems.size();
        String itemCount = this.checkedItemItems.size() + "/" + this.itemItems.size();
        if (this.blockItems.size() > 0) {
            this.screen.drawString(blockCount, this.screen.pageStartX + 163 - 12 - this.screen.getStringWidth(blockCount), this.screen.pageStartY + 39, -1, this.checkedBlockItems.size() == this.blockItems.size() ? 16766720 : 0);
        }
        if (this.itemItems.size() > 0) {
            this.screen.drawString(itemCount, this.screen.pageStartX + 163 - 12 - this.screen.getStringWidth(itemCount), this.blockItems.size() == 0 ? this.screen.pageStartY + 39 : this.screen.pageStartY + 39 + 9 + 6, -1, this.checkedItemItems.size() == this.itemItems.size() ? 16766720 : 0);
        }
    }

    private void discardAndShowTitlePage() {
        this.clearButtons();
        this.screen.showTitlePage();
    }

    private void discardAndShowItemPage(String category) {
        this.clearButtons();
        if (category.equals("item")) {
            this.screen.showItemPage(this.modInfo, category, this.itemItems, this.checkedItemItems);
        } else {
            this.screen.showItemPage(this.modInfo, category, this.blockItems, this.checkedBlockItems);
        }
    }
}

