/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.travelers_index.client.pages;

import com._idrae.travelers_index.client.buttons.BackButton;
import com._idrae.travelers_index.client.buttons.IndexChangePageButton;
import com._idrae.travelers_index.client.gui.IndexScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class Page {
    public static final int PAGE_MARGIN_X = 18;
    public static final int PAGE_MARGIN_Y = 18;
    public static final int PAGE_MARGIN_X_RIGHT = 12;
    protected static final int PAGE_GAP_X = 155;
    private static final int BACK_BUTTON_MARGIN_Y = 14;
    private static final int PREVIOUS_BUTTON_MARGIN_X = 25;
    private static final int NEXT_BUTTON_MARGIN_X = 282;
    private static final int CHANGE_BUTTONS_MARGIN_Y = 204;
    private static final int PAGE_NUM_MARGIN_X = 244;
    private static final int PAGE_NUM_MARGIN_Y = 16;
    protected IndexScreen screen;
    protected int page = 0;
    protected int numPages;
    protected BackButton backButton;
    protected IndexChangePageButton previousButton;
    protected IndexChangePageButton nextButton;

    public Page(IndexScreen screen) {
        this.screen = screen;
    }

    public void initBackButton(Button.IPressable onPress) {
        this.backButton = new BackButton(this.screen.pageStartX + 18, this.screen.pageStartY + 14, onPress);
        this.screen.addButton(this.backButton);
    }

    public void initChangePageButtons(Button.IPressable onPressPrevious, Button.IPressable onPressNext, int page, int numPages) {
        this.previousButton = new IndexChangePageButton(this.screen.pageStartX + 25, this.screen.pageStartY + 204, true, page, numPages, onPressPrevious);
        this.nextButton = new IndexChangePageButton(this.screen.pageStartX + 282, this.screen.pageStartY + 204, false, page, numPages, onPressNext);
        this.screen.addButton(this.previousButton);
        this.screen.addButton(this.nextButton);
    }

    protected void updateChangePageButtons() {
        this.previousButton.page = this.page;
        this.nextButton.page = this.page;
    }

    protected int computePageNumber(int numEntries, int numEntriesPerPage) {
        return numEntries % numEntriesPerPage == 0 ? numEntries / numEntriesPerPage : numEntries / numEntriesPerPage + 1;
    }

    protected void drawPageCount() {
        String string = this.page + 1 + "/" + this.numPages;
        this.screen.drawString(string, this.screen.pageStartX + 244 - this.screen.getStringWidth(string) / 2, this.screen.pageStartY + 16, -1, 0);
    }

    public void clearButtons() {
        if (this.backButton != null) {
            this.backButton.visible = false;
        }
        if (this.previousButton != null) {
            this.previousButton.visible = false;
        }
        if (this.nextButton != null) {
            this.nextButton.visible = false;
        }
    }
}

