/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.travelers_index.client.pages;

import com._idrae.travelers_index.client.buttons.TextButton;
import com._idrae.travelers_index.client.gui.IndexScreen;
import com._idrae.travelers_index.client.pages.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

@OnlyIn(value=Dist.CLIENT)
public class TitlePage
extends Page {
    private static final int POST_TITLE_GAP = 8;
    private static final int NUM_MODS_PER_PAGE = 20;
    private final HashMap<ModInfo, ArrayList<Item>> allItems;
    private final HashMap<ModInfo, Integer[]> counts;
    private List<ModInfo> modList;
    private ArrayList<TextButton> textButtons;

    public TitlePage(IndexScreen screen, HashMap<ModInfo, ArrayList<Item>> allItems, HashMap<ModInfo, Integer[]> counts) {
        super(screen);
        this.allItems = allItems;
        this.counts = counts;
    }

    public void init() {
        this.numPages = this.computePageNumber(this.allItems.keySet().size(), 20);
        this.modList = new ArrayList<ModInfo>(this.allItems.keySet());
        ModInfo mcInfo = null;
        for (ModInfo mod : this.modList) {
            if (!mod.getNamespace().equals("minecraft")) continue;
            mcInfo = mod;
            break;
        }
        Collections.swap(this.modList, this.modList.indexOf(mcInfo), 0);
        this.initChangePageButtons(button -> this.previousPage(), button -> this.nextPage(), this.page, this.numPages);
        this.initTextButtons();
    }

    private void initTextButtons() {
        this.textButtons = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            int index = this.page * 20 + i;
            if (index >= this.modList.size()) continue;
            ModInfo mod = this.modList.get(index);
            String modName = mod.getDisplayName();
            int numModsPerHalfPage = 10;
            boolean onLeftPage = i < numModsPerHalfPage;
            int color = this.counts.get(mod)[0].equals(this.counts.get(mod)[1]) ? 16766720 : 0;
            TextButton textButton = new TextButton(this.screen, onLeftPage ? this.screen.pageStartX + 18 : this.screen.pageStartX + 18 + 155, onLeftPage ? this.screen.pageStartY + 18 + 8 + (i + 1) * 15 : this.screen.pageStartY + 18 + 8 + (i - numModsPerHalfPage + 1) * 15, Math.min(this.screen.getStringWidth(modName), 90), modName, color, button -> this.discardAndShowModPage(mod));
            this.textButtons.add(textButton);
            this.screen.addButton(textButton);
        }
    }

    private void previousPage() {
        if (this.numPages > 1) {
            this.page = this.page == 0 ? this.numPages - 1 : --this.page;
            this.clearButtons();
            this.initTextButtons();
            this.initChangePageButtons(button -> this.previousPage(), button -> this.nextPage(), this.page, this.numPages);
            this.updateChangePageButtons();
        }
    }

    private void nextPage() {
        if (this.numPages > 1) {
            this.page = this.page == this.numPages - 1 ? 0 : ++this.page;
            this.clearButtons();
            this.initTextButtons();
            this.initChangePageButtons(button -> this.previousPage(), button -> this.nextPage(), this.page, this.numPages);
            this.updateChangePageButtons();
        }
    }

    public void render() {
        this.drawTitle();
        this.drawModCounts();
        this.drawPageCount();
    }

    public void renderTooltips(int mouseX, int mouseY) {
        for (TextButton button : this.textButtons) {
            if (!button.isHovered() || !button.isTooLong) continue;
            this.screen.renderTooltip(button.text, mouseX, mouseY);
        }
        for (int i = 0; i < 20; ++i) {
            boolean onLeftPage;
            int index = this.page * 20 + i;
            if (index >= this.modList.size()) continue;
            ModInfo mod = this.modList.get(index);
            Integer checked = this.counts.get(mod)[0];
            Integer total = this.counts.get(mod)[1];
            if (total == 0) {
                total = 1;
            }
            String string = checked.toString() + "/" + total.toString();
            int numModsPerHalfPage = 10;
            boolean bl = onLeftPage = i < numModsPerHalfPage;
            boolean isHovered = onLeftPage ? mouseX >= this.screen.pageStartX + 163 - 12 - this.screen.getStringWidth(string) && mouseX < this.screen.pageStartX + 163 - 12 && mouseY >= this.screen.pageStartY + 18 + 8 + (i + 1) * 15 && mouseY < this.screen.pageStartY + 18 + 8 + (i + 1) * 15 + 9 : mouseX >= this.screen.pageStartX + 163 + 155 - 12 - this.screen.getStringWidth(string) && mouseX < this.screen.pageStartX + 163 + 155 - 12 && mouseY >= this.screen.pageStartY + 18 + 8 + (i - numModsPerHalfPage + 1) * 15 && mouseY < this.screen.pageStartY + 18 + 8 + (i - numModsPerHalfPage + 1) * 15 + 9;
            Integer percentage = checked * 100 / total;
            if (!isHovered) continue;
            this.screen.renderTooltip(percentage.toString() + "%", mouseX, mouseY);
        }
    }

    private void drawTitle() {
        String title = "Traveler's Index";
        this.screen.drawString(title, this.screen.pageStartX + (163 - this.screen.getStringWidth(title)) / 2, this.screen.pageStartY + 18, -1, 13542239);
    }

    private void drawModCounts() {
        for (int i = 0; i < 20; ++i) {
            int index = this.page * 20 + i;
            if (index >= this.modList.size()) continue;
            ModInfo mod = this.modList.get(index);
            String string = this.counts.get(mod)[0].toString() + "/" + this.counts.get(mod)[1].toString();
            int numModsPerHalfPage = 10;
            boolean onLeftPage = i < numModsPerHalfPage;
            this.screen.drawString(string, onLeftPage ? this.screen.pageStartX + 163 - 12 - this.screen.getStringWidth(string) : this.screen.pageStartX + 163 + 155 - 12 - this.screen.getStringWidth(string), onLeftPage ? this.screen.pageStartY + 18 + 8 + (i + 1) * 15 : this.screen.pageStartY + 18 + 8 + (i - numModsPerHalfPage + 1) * 15, -1, this.counts.get(mod)[0].equals(this.counts.get(mod)[1]) ? 16766720 : 0);
        }
    }

    private void discardAndShowModPage(ModInfo mod) {
        this.clearButtons();
        this.screen.showModPage(mod);
    }

    @Override
    public void clearButtons() {
        for (TextButton button : this.textButtons) {
            button.visible = false;
        }
        super.clearButtons();
    }
}

