/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.travelers_index.data;

import com._idrae.travelers_index.TravelersIndex;
import com._idrae.travelers_index.data.ItemChecklist;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemChecklistStorage
implements Capability.IStorage<ItemChecklist> {
    private static final String ITEMS_KEY = "items";
    private static final String ITEM_KEY = "item";
    private static final String TIMES_KEY = "times";
    private static final String TIME_KEY = "time";
    private static final String VERSION_KEY = "version";

    @Nullable
    public INBT writeNBT(Capability<ItemChecklist> capability, ItemChecklist instance, Direction side) {
        CompoundNBT mainNBT = new CompoundNBT();
        ListNBT itemsNBT = new ListNBT();
        ListNBT timesNBT = new ListNBT();
        HashMap<Item, Integer> checklist = instance.getChecklist();
        for (Item item : checklist.keySet()) {
            CompoundNBT itemNBT = new CompoundNBT();
            itemNBT.func_74778_a(ITEM_KEY, item.getRegistryName().toString());
            itemsNBT.add((Object)itemNBT);
        }
        Iterator<Object> iterator = checklist.values().iterator();
        while (iterator.hasNext()) {
            int time = (Integer)iterator.next();
            CompoundNBT timeNBT = new CompoundNBT();
            timeNBT.func_74768_a(TIME_KEY, time);
            timesNBT.add((Object)timeNBT);
        }
        mainNBT.func_218657_a(ITEMS_KEY, (INBT)itemsNBT);
        mainNBT.func_218657_a(TIMES_KEY, (INBT)timesNBT);
        mainNBT.func_74768_a(VERSION_KEY, instance.getVersion());
        TravelersIndex.LOGGER.info("capability written.");
        return mainNBT;
    }

    public void readNBT(Capability<ItemChecklist> capability, ItemChecklist instance, Direction side, INBT nbt) {
        ListNBT itemsNBT = (ListNBT)((CompoundNBT)nbt).func_74781_a(ITEMS_KEY);
        ListNBT timesNBT = (ListNBT)((CompoundNBT)nbt).func_74781_a(TIMES_KEY);
        HashMap<Item, Integer> checklist = new HashMap<Item, Integer>();
        for (int j = 0; j < itemsNBT.size(); ++j) {
            CompoundNBT itemNBT = itemsNBT.func_150305_b(j);
            CompoundNBT timeNBT = timesNBT.func_150305_b(j);
            String itemName = itemNBT.func_74779_i(ITEM_KEY);
            int time = timeNBT.func_74762_e(TIME_KEY);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            if (item == null) continue;
            checklist.put(item, time);
        }
        int version = ((CompoundNBT)nbt).func_74762_e(VERSION_KEY);
        instance.setItemChecklist(checklist);
        instance.setVersion(version);
        TravelersIndex.LOGGER.info("capability read.");
    }
}

