/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.travelers_index.events;

import com._idrae.travelers_index.TravelersIndex;
import com._idrae.travelers_index.data.ItemChecklist;
import com._idrae.travelers_index.data.ItemChecklistProvider;
import com._idrae.travelers_index.network.PacketHandler;
import com._idrae.travelers_index.network.SendCheckListToClientPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="travelers_index", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventBusSubscriber {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemChecklist checklist = (ItemChecklist)player.getCapability(ItemChecklistProvider.ITEM_CHECKLIST_CAPABILITY).orElseThrow(IllegalStateException::new);
        if (checklist.getChecklist() == null) {
            checklist.init();
            TravelersIndex.LOGGER.info("checklist initialized on server.");
        }
        PacketHandler.HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SendCheckListToClientPacket(checklist));
    }

    @SubscribeEvent
    public static void onItemPickedUp(PlayerEvent.ItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemChecklist checklist = (ItemChecklist)player.getCapability(ItemChecklistProvider.ITEM_CHECKLIST_CAPABILITY, null).orElseThrow(IllegalStateException::new);
        Item item = event.getStack().func_77973_b();
        if (checklist.getChecklist() != null) {
            if (!checklist.getChecklist().containsKey(item)) {
                int time = (int)(event.getPlayer().field_70170_p.func_82737_E() % Integer.MAX_VALUE);
                checklist.getChecklist().put(item, time);
                TravelersIndex.LOGGER.info(item.getRegistryName().toString() + " added to server checklist!");
            }
            PacketHandler.HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SendCheckListToClientPacket(checklist));
        }
    }

    @SubscribeEvent
    public static void onPlayerContainerClosed(PlayerContainerEvent.Close event) {
        PlayerEntity player = event.getPlayer();
        ItemChecklist checklist = (ItemChecklist)player.getCapability(ItemChecklistProvider.ITEM_CHECKLIST_CAPABILITY, null).orElseThrow(IllegalStateException::new);
        PlayerContainer inventory = player.field_71069_bz;
        if (checklist.getChecklist() != null) {
            for (Slot slot : inventory.field_75151_b) {
                Item item = slot.func_75211_c().func_77973_b();
                if (checklist.getChecklist().containsKey(item)) continue;
                int time = (int)(event.getPlayer().field_70170_p.func_82737_E() % Integer.MAX_VALUE);
                checklist.getChecklist().put(item, time);
                TravelersIndex.LOGGER.info(item.getRegistryName().toString() + " added to checklist!");
            }
            PacketHandler.HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SendCheckListToClientPacket(checklist));
        }
    }

    @SubscribeEvent
    public static void onPlayerDead(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            PlayerEntity deadPlayer = event.getOriginal();
            PlayerEntity player = event.getPlayer();
            ItemChecklist oldChecklist = (ItemChecklist)deadPlayer.getCapability(ItemChecklistProvider.ITEM_CHECKLIST_CAPABILITY, null).orElseThrow(IllegalStateException::new);
            ItemChecklist newChecklist = (ItemChecklist)player.getCapability(ItemChecklistProvider.ITEM_CHECKLIST_CAPABILITY, null).orElseThrow(IllegalStateException::new);
            newChecklist.setItemChecklist(oldChecklist.getChecklist());
            TravelersIndex.LOGGER.info("checklist retrieved from dead player.");
        }
    }
}

