/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.travelers_index.client.gui;

import com._idrae.travelers_index.client.pages.ItemPage;
import com._idrae.travelers_index.client.pages.ModPage;
import com._idrae.travelers_index.client.pages.TitlePage;
import com._idrae.travelers_index.client.util.ItemBlacklist;
import com._idrae.travelers_index.data.ItemChecklist;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class IndexScreen
extends Screen {
    private String pageType = "title";
    private TitlePage titlePage;
    private ModPage modPage;
    private ItemPage itemPage;
    public static final int TEXTURE_HEIGHT = 228;
    public static final int TEXTURE_WIDTH = 163;
    public int pageStartX;
    public int pageStartY = 2;
    public static final int STRING_GAP = 6;
    public static final int STRING_HEIGHT = 9;
    public static ItemChecklist checklist;
    public HashMap<ModInfo, ArrayList<Item>> orderedChecklist;
    public HashMap<Item, Integer> obtainmentDates;
    public HashMap<ModInfo, ArrayList<Item>> allItems;
    public HashMap<ModInfo, Integer[]> counts;
    public static final ResourceLocation LEFT_TEXTURE;
    public static final ResourceLocation RIGHT_TEXTURE;

    public IndexScreen() {
        super((ITextComponent)new StringTextComponent("travelers_index"));
    }

    protected void func_231160_c_() {
        this.initChecklist();
        this.pageStartX = (this.field_230708_k_ - 324) / 2;
        this.titlePage = new TitlePage(this, this.allItems, this.counts);
        this.titlePage.init();
    }

    private void initChecklist() {
        this.orderedChecklist = new HashMap();
        this.obtainmentDates = new HashMap();
        this.allItems = new HashMap();
        this.counts = new HashMap();
        for (ModInfo mod : ModList.get().getMods()) {
            ArrayList<Item> modChecklist = new ArrayList<Item>();
            ArrayList<Item> allModItems = new ArrayList<Item>();
            Integer[] count = new Integer[2];
            Collection items = ForgeRegistries.ITEMS.getValues();
            for (Item item : items) {
                if (ItemBlacklist.INSTANCE.contains(item) || !item.getRegistryName().func_110624_b().equals(mod.getNamespace())) continue;
                allModItems.add(item);
                if (!checklist.getChecklist().containsKey(item)) continue;
                modChecklist.add(item);
                this.obtainmentDates.put(item, checklist.getChecklist().get(item));
            }
            if (allModItems.size() <= 0) continue;
            count[0] = modChecklist.size();
            count[1] = allModItems.size();
            this.orderedChecklist.put(mod, modChecklist);
            this.allItems.put(mod, allModItems);
            this.counts.put(mod, count);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.showBookTexture(matrixStack);
        switch (this.pageType) {
            case "title": {
                this.titlePage.render(matrixStack);
                break;
            }
            case "mod": {
                this.modPage.render(matrixStack);
                break;
            }
            default: {
                this.itemPage.render(matrixStack);
            }
        }
        this.renderTooltips(matrixStack, mouseX, mouseY);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        switch (this.pageType) {
            case "title": {
                this.titlePage.renderTooltips(matrixStack, mouseX, mouseY);
                break;
            }
            case "mod": {
                this.modPage.renderTooltips(matrixStack, mouseX, mouseY);
                break;
            }
            default: {
                this.itemPage.renderTooltips(matrixStack, mouseX, mouseY);
            }
        }
    }

    public void func_231152_a_(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        this.field_230706_i_ = p_resize_1_;
        this.field_230708_k_ = p_resize_2_;
        this.field_230709_l_ = p_resize_3_;
        this.pageStartX = (this.field_230708_k_ - 324) / 2;
        switch (this.pageType) {
            case "title": {
                this.titlePage.clearButtons();
                this.titlePage.init();
                break;
            }
            case "mod": {
                this.modPage.clearButtons();
                this.modPage.init();
                break;
            }
            default: {
                this.itemPage.clearButtons();
                this.itemPage.init();
            }
        }
    }

    public void drawString(MatrixStack matrixStack, String s, int posX, int posY, int maxWidth, int color) {
        String trimmedString;
        if (maxWidth < 0) {
            trimmedString = s;
        } else {
            trimmedString = s;
            boolean flag = false;
            while (this.getStringWidth(trimmedString) > maxWidth) {
                trimmedString = trimmedString.substring(0, trimmedString.length() - 1);
                flag = true;
            }
            if (flag) {
                trimmedString = trimmedString + "...";
            }
        }
        this.field_230712_o_.func_238421_b_(matrixStack, trimmedString, (float)posX, (float)posY, color);
    }

    public int getStringWidth(String s) {
        return this.field_230712_o_.func_78256_a(this.field_230712_o_.func_78260_a() ? this.field_230712_o_.func_147647_b(s) : s);
    }

    private void showBookTexture(MatrixStack matrixStack) {
        this.field_230706_i_.func_110434_K().func_110577_a(LEFT_TEXTURE);
        this.func_238474_b_(matrixStack, this.pageStartX, this.pageStartY, 0, 0, 163, 228);
        this.field_230706_i_.func_110434_K().func_110577_a(RIGHT_TEXTURE);
        this.func_238474_b_(matrixStack, this.pageStartX + 163, this.pageStartY, 0, 0, 163, 228);
    }

    public <T extends Button> void addButton(T button) {
        super.func_230480_a_(button);
    }

    public void showTitlePage() {
        this.pageType = "title";
        this.titlePage = new TitlePage(this, this.allItems, this.counts);
        this.titlePage.init();
    }

    public void showModPage(ModInfo mod) {
        this.pageType = "mod";
        this.modPage = new ModPage(this, mod, this.allItems.get(mod), this.orderedChecklist.get(mod));
        this.modPage.init();
    }

    public void showItemPage(ModInfo mod, String category, ArrayList<Item> items, ArrayList<Item> checkedItems) {
        this.pageType = "item";
        this.itemPage = new ItemPage(this, category, mod, items, checkedItems, this.obtainmentDates);
        this.itemPage.init();
    }

    static {
        LEFT_TEXTURE = new ResourceLocation("travelers_index", "textures/gui/index_left.png");
        RIGHT_TEXTURE = new ResourceLocation("travelers_index", "textures/gui/index_right.png");
    }
}

