/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod;

import dev.toma.vehiclemod.Registries;
import dev.toma.vehiclemod.common.VMTab;
import dev.toma.vehiclemod.common.blocks.fuel.TileEntityFuelMaker;
import dev.toma.vehiclemod.common.capability.chunks.ChunkData;
import dev.toma.vehiclemod.common.capability.chunks.ChunkDataFactory;
import dev.toma.vehiclemod.common.tileentity.TileEntityMechanicPackage;
import dev.toma.vehiclemod.common.tileentity.TileEntityPetrolPump;
import dev.toma.vehiclemod.common.tileentity.TileEntitySecret;
import dev.toma.vehiclemod.common.tileentity.TileEntityTunerPackage;
import dev.toma.vehiclemod.common.world.PackageGenerator;
import dev.toma.vehiclemod.config.VehicleStats;
import dev.toma.vehiclemod.network.VMNetworkManager;
import dev.toma.vehiclemod.proxy.CommonProxy;
import dev.toma.vehiclemod.util.DummyStorage;
import dev.toma.vehiclemod.util.GuiHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="vehiclemod", name="Vehicle mod", version="1.1.0", updateJSON="https://raw.githubusercontent.com/Toma1O6/vehicle-mod/master/updatechecker.json", acceptedMinecraftVersions="[1.12.2]")
public class VehicleMod {
    public static final String MODID = "vehiclemod";
    @Mod.Instance
    public static VehicleMod instance;
    @SidedProxy(clientSide="dev.toma.vehiclemod.proxy.ClientProxy", serverSide="dev.toma.vehiclemod.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static final Random random;
    public static final VMTab TAB;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        VMNetworkManager.init();
        proxy.preInit(e);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CapabilityManager.INSTANCE.register(ChunkData.class, new DummyStorage(), ChunkDataFactory::new);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent e) {
        GameRegistry.registerTileEntity(TileEntityPetrolPump.class, (ResourceLocation)VehicleMod.getResource("petrol_pump"));
        GameRegistry.registerTileEntity(TileEntityFuelMaker.class, (ResourceLocation)VehicleMod.getResource("fuel_maker"));
        GameRegistry.registerTileEntity(TileEntityMechanicPackage.class, (ResourceLocation)VehicleMod.getResource("mechanic_package"));
        GameRegistry.registerTileEntity(TileEntityTunerPackage.class, (ResourceLocation)VehicleMod.getResource("tuner_package"));
        GameRegistry.registerTileEntity(TileEntitySecret.class, (ResourceLocation)VehicleMod.getResource("secret"));
        GameRegistry.registerWorldGenerator((IWorldGenerator)new PackageGenerator(), (int)0);
        proxy.init(e);
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
        VehicleStats.initiateValueRefresh();
    }

    public static void registerItemBlock(Block block) {
        ItemBlock ib = new ItemBlock(block);
        ib.setRegistryName(block.getRegistryName());
        Registries.Registry.ITEM_BLOCKS.add(ib);
    }

    public static ResourceLocation getResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static boolean isDevEnvironment() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    static {
        random = new Random();
        TAB = new VMTab();
    }
}

