/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.client.SpeedDisplayUnit;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.NitroHandler;
import dev.toma.vehiclemod.common.items.ItemNitroCan;
import dev.toma.vehiclemod.common.items.ItemPerk;
import dev.toma.vehiclemod.common.items.ItemVehicleUpgrade;
import dev.toma.vehiclemod.config.VMConfig;
import dev.toma.vehiclemod.config.VehicleStats;
import dev.toma.vehiclemod.network.VMNetworkManager;
import dev.toma.vehiclemod.network.packets.SPacketOpenVehicleComponentGUI;
import dev.toma.vehiclemod.util.DevUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientEventHandler {
    private static final ResourceLocation VEHICLE_HUD = new ResourceLocation("vehiclemod:textures/entity/vehicle_hud.png");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void openGUI(GuiOpenEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getGui() instanceof InventoryEffectRenderer && player.func_184187_bx() instanceof EntityVehicle) {
            event.setCanceled(true);
            VMNetworkManager.instance().sendToServer((IMessage)new SPacketOpenVehicleComponentGUI(3));
        }
    }

    @SubscribeEvent
    public static void stitchTextures(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        for (ItemVehicleUpgrade.Type type : ItemVehicleUpgrade.Type.values()) {
            for (int i2 = 0; i2 < 8; ++i2) {
                map.func_174942_a(VehicleMod.getResource("items/" + type.name().toLowerCase() + "_" + i2));
            }
        }
        List perks = ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof ItemPerk).map(i -> (ItemPerk)((Object)i)).collect(Collectors.toList());
        for (ItemPerk perk : perks) {
            ResourceLocation name = perk.getRegistryName();
            map.func_174942_a(new ResourceLocation(name.func_110624_b(), "items/" + name.func_110623_a()));
        }
        map.func_174942_a(VehicleMod.getResource("items/perk_empty"));
        map.func_174942_a(VehicleMod.getResource("items/filter_empty"));
        map.func_174942_a(VehicleMod.getResource("items/bucket_empty"));
        map.func_174942_a(VehicleMod.getResource("items/neon_empty"));
        map.func_174942_a(VehicleMod.getResource("items/neon_pulser_empty"));
        map.func_174942_a(VehicleMod.getResource("items/nitro_can_empty"));
        map.func_174942_a(VehicleMod.getResource("items/nitro_cloud_spray_empty"));
        map.func_174942_a(VehicleMod.getResource("items/nitro_cloud_spray_empty_disabled"));
        map.func_174942_a(VehicleMod.getResource("items/nitro_led_empty"));
    }

    @SubscribeEvent
    public static void setupCamera(EntityViewRenderEvent.CameraSetup event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 1) {
            return;
        }
        if (event.getEntity().func_184218_aH() && event.getEntity().func_184187_bx() instanceof EntityVehicle) {
            EntityVehicle vehicle = (EntityVehicle)event.getEntity().func_184187_bx();
            VehicleStats.Vector3i vector3i = vehicle.getConfigStats().cameraOff;
            GlStateManager.func_179109_b((float)vector3i.getX(), (float)vector3i.getY(), (float)vector3i.getZ());
        }
    }

    @SubscribeEvent
    public static void renderOverlayEvent(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution resolution = e.getResolution();
            EntityPlayerSP player = mc.field_71439_g;
            if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityVehicle) {
                EntityVehicle car = (EntityVehicle)player.func_184187_bx();
                float fuel = car.fuel / (float)car.getActualStats().fuelCapacity;
                boolean lowFuel = fuel <= 0.17f;
                float health = car.health / car.getActualStats().maxHealth;
                boolean lowHealth = (double)health <= 0.5;
                double speed = Math.sqrt(car.field_70159_w * car.field_70159_w + car.field_70179_y * car.field_70179_y) * 40.0;
                SpeedDisplayUnit unit = VMConfig.speedUnit;
                String speedString = unit.getDisplayString(speed);
                mc.field_71466_p.func_175063_a(speedString, 16.0f, (float)(resolution.func_78328_b() - 35), 0xFFFFFF);
                if (car.isEcoMode()) {
                    mc.field_71466_p.func_175063_a("Eco", 16.0f, (float)(resolution.func_78328_b() - 45), 65280);
                }
                NitroHandler nitroHandler = car.getNitroHandler();
                InventoryBasic nitroInventory = nitroHandler.getInventory();
                for (int i = 0; i < 5; ++i) {
                    ItemStack stack = nitroInventory.func_70301_a(i);
                    ResourceLocation icon = ItemNitroCan.EMPTY_ICON;
                    if (stack.func_77973_b() instanceof ItemNitroCan) {
                        boolean flag;
                        boolean bl = flag = nitroHandler.isNitroActive() && nitroHandler.getActiveSlot() == i;
                        if (stack.func_77952_i() < stack.func_77958_k() || flag) {
                            ItemNitroCan can = (ItemNitroCan)stack.func_77973_b();
                            icon = flag ? can.getIcon_active() : can.getIcon_available();
                        }
                    }
                    DevUtil.drawImage2D(mc, icon, 74 + i * 10, resolution.func_78328_b() - 40, 16, 16);
                }
                VehicleHUDType type = VehicleHUDType.FUEL_STATE;
                int x = 15;
                int y = resolution.func_78328_b() - 15;
                int w = 104 - x + 1;
                int h = 8;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder builder = tessellator.func_178180_c();
                GlStateManager.func_179090_x();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179103_j((int)7425);
                builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                builder.func_181662_b((double)x, (double)(y + h), 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                builder.func_181662_b((double)((float)x + (float)w * fuel), (double)(y + h), 0.0).func_181666_a(1.0f * (1.0f - fuel), 1.0f * fuel, 0.0f, 1.0f).func_181675_d();
                builder.func_181662_b((double)((float)x + (float)w * fuel), (double)y, 0.0).func_181666_a(1.0f * (1.0f - fuel), 1.0f * fuel, 0.0f, 1.0f).func_181675_d();
                builder.func_181662_b((double)x, (double)y, 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179103_j((int)7424);
                GlStateManager.func_179084_k();
                GlStateManager.func_179098_w();
                DevUtil.drawImage2D(mc, VEHICLE_HUD, 0, resolution.func_78328_b() - 25, 120, 20, type.uv.uStart, type.uv.vStart, type.uv.uEnd, type.uv.vEnd);
                type = lowFuel ? VehicleHUDType.FUEL_LOW : VehicleHUDType.FUEL;
                DevUtil.drawImage2D(mc, VEHICLE_HUD, 110, resolution.func_78328_b() - 26, 20, 20, type.uv.uStart, type.uv.vStart, type.uv.uEnd, type.uv.vEnd);
                type = VehicleHUDType.INDICATOR;
                DevUtil.drawImage2D(mc, VEHICLE_HUD, (int)(-1.0f + fuel * 90.0f), resolution.func_78328_b() - 30, 32, 25, type.uv.uStart, type.uv.vStart, type.uv.uEnd, type.uv.vEnd);
                if (!lowHealth) {
                    return;
                }
                type = health <= 0.25f ? VehicleHUDType.ENGINE_FATAL : VehicleHUDType.ENGINE_WARN;
                DevUtil.drawImage2D(mc, VEHICLE_HUD, 128, resolution.func_78328_b() - 25, 20, 20, type.uv.uStart, type.uv.vStart, type.uv.uEnd, type.uv.vEnd);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPre(RenderPlayerEvent.Pre e) {
        GlStateManager.func_179094_E();
        if (e.getEntityPlayer().func_184218_aH() && e.getEntityPlayer().func_184187_bx() instanceof EntityVehicle) {
            GlStateManager.func_179137_b((double)0.0, (double)0.6, (double)0.0);
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post e) {
        GlStateManager.func_179121_F();
    }

    private static class UVCoords {
        public final double uStart;
        public final double uEnd;
        public final double vStart;
        public final double vEnd;

        public UVCoords(double d0, double d1, double d2, double d3) {
            this.uStart = d0;
            this.vStart = d1;
            this.uEnd = d2;
            this.vEnd = d3;
        }
    }

    private static enum VehicleHUDType {
        FUEL(new UVCoords(0.0, 0.0, 0.5, 0.5)),
        FUEL_LOW(new UVCoords(0.5, 0.0, 1.0, 0.5)),
        FUEL_STATE(new UVCoords(0.0, 0.5, 1.0, 0.625)),
        INDICATOR(new UVCoords(0.0, 0.625, 0.125, 0.7421875)),
        ENGINE_WARN(new UVCoords(0.0, 0.75, 0.25, 1.0)),
        ENGINE_FATAL(new UVCoords(0.25, 0.75, 0.5, 1.0));

        public final UVCoords uv;

        private VehicleHUDType(UVCoords uv) {
            this.uv = uv;
        }
    }
}

