/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client;

import java.util.function.Function;

public enum SpeedDisplayUnit {
    BLOCK_PER_SECOND("bps", s -> s),
    KILOMETRES_PER_HOUR("km/h", s -> s * 3.6),
    MILES_PER_HOUR("mph", s -> s * 2.23693629);

    private final Function<Double, Double> convertFunction;
    private final String unitName;

    private SpeedDisplayUnit(String displayName, Function<Double, Double> convertFunction) {
        this.unitName = displayName;
        this.convertFunction = convertFunction;
    }

    public double getSpeed(double vehicleSpeed) {
        return this.convertFunction.apply(vehicleSpeed);
    }

    public String getDisplayString(double speed) {
        return Math.round(this.convertFunction.apply(speed)) + " " + this.unitName;
    }

    public String getUnitName() {
        return this.unitName;
    }
}

