/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.ISpecialVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.LightController;
import dev.toma.vehiclemod.common.entity.vehicle.NitroHandler;
import dev.toma.vehiclemod.network.VMNetworkManager;
import dev.toma.vehiclemod.network.packets.SPacketChangeLightStatus;
import dev.toma.vehiclemod.network.packets.SPacketCloudStatus;
import dev.toma.vehiclemod.network.packets.SPacketHonk;
import dev.toma.vehiclemod.network.packets.SPacketSiren;
import dev.toma.vehiclemod.network.packets.SPacketVehicleAction;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class VMKeybinds {
    static final String CATEGORY = "category.vehiclemod";
    public static KeyBinding CAR_SIREN;
    public static KeyBinding CAR_HORN;
    public static KeyBinding CAR_LIGHTS;
    public static KeyBinding INDICATOR_RIGHT;
    public static KeyBinding INDICATOR_LEFT;
    public static KeyBinding INDICATOR_WARNING;
    public static KeyBinding ECO_MODE;
    public static KeyBinding START;
    public static KeyBinding NITRO;
    static KeyStateListener hornKeyListener;
    static KeyStateListener nitroKeyListener;

    public static void init() {
        CAR_SIREN = new KeyBinding("key.vehiclemod.car_siren", 34, CATEGORY);
        CAR_HORN = new KeyBinding("key.vehiclemod.car_horn", 35, CATEGORY);
        CAR_LIGHTS = new KeyBinding("key.vehiclemod.car_lights", 38, CATEGORY);
        INDICATOR_RIGHT = new KeyBinding("key.vehiclemod.indicator_right", 47, CATEGORY);
        INDICATOR_LEFT = new KeyBinding("key.vehiclemod.indicator_left", 45, CATEGORY);
        INDICATOR_WARNING = new KeyBinding("key.vehiclemod.indicator_warning", 46, CATEGORY);
        ECO_MODE = new KeyBinding("key.vehiclemod.eco_mode", 37, CATEGORY);
        START = new KeyBinding("key.vehiclemod.start", 19, CATEGORY);
        NITRO = new KeyBinding("key.vehiclemod.nitro", 29, CATEGORY);
        ClientRegistry.registerKeyBinding((KeyBinding)CAR_SIREN);
        ClientRegistry.registerKeyBinding((KeyBinding)CAR_HORN);
        ClientRegistry.registerKeyBinding((KeyBinding)CAR_LIGHTS);
        ClientRegistry.registerKeyBinding((KeyBinding)INDICATOR_RIGHT);
        ClientRegistry.registerKeyBinding((KeyBinding)INDICATOR_LEFT);
        ClientRegistry.registerKeyBinding((KeyBinding)INDICATOR_WARNING);
        ClientRegistry.registerKeyBinding((KeyBinding)ECO_MODE);
        ClientRegistry.registerKeyBinding((KeyBinding)START);
        ClientRegistry.registerKeyBinding((KeyBinding)NITRO);
    }

    @SubscribeEvent
    public static void keyInput(InputEvent.KeyInputEvent event) {
        Entity entity;
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (CAR_SIREN.func_151468_f()) {
            Entity entity2 = player.func_184187_bx();
            if (entity2 instanceof ISpecialVehicle && player == entity2.func_184179_bs()) {
                VMNetworkManager.instance().sendToServer((IMessage)new SPacketSiren());
            }
        } else if (CAR_LIGHTS.func_151468_f()) {
            Entity entity3 = player.func_184187_bx();
            if (entity3 instanceof EntityVehicle && player == entity3.func_184179_bs()) {
                EntityVehicle vehicle = (EntityVehicle)entity3;
                VMNetworkManager.instance().sendToServer((IMessage)SPacketChangeLightStatus.headlights(vehicle, !vehicle.lightController.getLightFlag()));
            }
        } else if (INDICATOR_RIGHT.func_151468_f()) {
            Entity entity4 = player.func_184187_bx();
            if (entity4 instanceof EntityVehicle && player == entity4.func_184179_bs()) {
                EntityVehicle vehicle = (EntityVehicle)entity4;
                VMNetworkManager.instance().sendToServer((IMessage)SPacketChangeLightStatus.turnStatus(vehicle, LightController.TurnLightStatus.RIGHT));
            }
        } else if (INDICATOR_LEFT.func_151468_f()) {
            Entity entity5 = player.func_184187_bx();
            if (entity5 instanceof EntityVehicle && player == entity5.func_184179_bs()) {
                EntityVehicle vehicle = (EntityVehicle)entity5;
                VMNetworkManager.instance().sendToServer((IMessage)SPacketChangeLightStatus.turnStatus(vehicle, LightController.TurnLightStatus.LEFT));
            }
        } else if (INDICATOR_WARNING.func_151468_f()) {
            Entity entity6 = player.func_184187_bx();
            if (entity6 instanceof EntityVehicle && player == entity6.func_184179_bs()) {
                EntityVehicle vehicle = (EntityVehicle)entity6;
                VMNetworkManager.instance().sendToServer((IMessage)SPacketChangeLightStatus.turnStatus(vehicle, LightController.TurnLightStatus.WARNING));
            }
        } else if (ECO_MODE.func_151468_f()) {
            Entity entity7 = player.func_184187_bx();
            if (entity7 instanceof EntityVehicle && player == entity7.func_184179_bs()) {
                EntityVehicle vehicle = (EntityVehicle)entity7;
                VMNetworkManager.instance().sendToServer((IMessage)SPacketVehicleAction.eco(!vehicle.isEcoMode()));
            }
        } else if (START.func_151468_f()) {
            EntityVehicle vehicle;
            Entity entity8 = player.func_184187_bx();
            if (entity8 instanceof EntityVehicle && player == entity8.func_184179_bs() && !(vehicle = (EntityVehicle)entity8).isStarted() && vehicle.getStartCooldown() == 0) {
                VMNetworkManager.instance().sendToServer((IMessage)SPacketVehicleAction.start());
            }
        } else if (NITRO.func_151468_f() && (entity = player.func_184187_bx()) instanceof EntityVehicle && player == entity.func_184179_bs()) {
            EntityVehicle vehicle = (EntityVehicle)entity;
            if (vehicle.isStationary()) {
                return;
            }
            NitroHandler handler = vehicle.getNitroHandler();
            int slot = handler.getFirstUsableNitroSlot();
            if (vehicle.isStarted() && slot != -1) {
                handler.initiateUse((Entity)player, slot);
                VMNetworkManager.instance().sendToServer((IMessage)SPacketVehicleAction.nitro(slot));
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (event.phase == TickEvent.Phase.END || player == null) {
            return;
        }
        Entity entity = player.func_184187_bx();
        if (entity instanceof EntityVehicle && entity.func_184179_bs() == player) {
            EntityVehicle vehicle = (EntityVehicle)entity;
            hornKeyListener.tick(vehicle);
            nitroKeyListener.tick(vehicle);
        }
    }

    static {
        hornKeyListener = new KeyStateListener(vehicle -> CAR_HORN.func_151470_d(), (aBoolean, vehicle) -> VMNetworkManager.instance().sendToServer((IMessage)new SPacketHonk((boolean)aBoolean, (EntityVehicle)vehicle)));
        nitroKeyListener = new KeyStateListener(vehicle -> {
            NitroHandler handler = vehicle.getNitroHandler();
            int nitroSlot = handler.getFirstUsableNitroSlot();
            return NITRO.func_151470_d() && nitroSlot >= 0 && vehicle.isStationary();
        }, (aBoolean, vehicle) -> VMNetworkManager.instance().sendToServer((IMessage)new SPacketCloudStatus((boolean)aBoolean)));
    }

    static class KeyStateListener {
        boolean savedState;
        final Predicate<EntityVehicle> condition;
        final BiConsumer<Boolean, EntityVehicle> action;

        KeyStateListener(Predicate<EntityVehicle> condition, BiConsumer<Boolean, EntityVehicle> action) {
            this.condition = condition;
            this.action = action;
        }

        void tick(EntityVehicle vehicle) {
            boolean actualState = this.condition.test(vehicle);
            if (actualState != this.savedState) {
                this.action.accept(actualState, vehicle);
            }
            this.savedState = actualState;
        }
    }
}

