/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import java.util.Objects;
import net.minecraft.util.SoundEvent;

public class VehicleSoundPack {
    final SoundEvent accelerate;
    final SoundEvent brake;
    final SoundEvent release;
    final SoundEvent start;
    final SoundEvent honk;
    final SoundEvent starting;

    private VehicleSoundPack(Builder<?> builder) {
        this.accelerate = builder.acc;
        this.brake = builder.brk;
        this.release = builder.rls;
        this.start = builder.str;
        this.honk = builder.honk;
        this.starting = builder.starting;
    }

    public SoundEvent accelerate() {
        return this.accelerate;
    }

    public SoundEvent brake() {
        return this.brake;
    }

    public SoundEvent release() {
        return this.release;
    }

    public SoundEvent start() {
        return this.start;
    }

    public SoundEvent honk() {
        return this.honk;
    }

    public SoundEvent starting() {
        return this.starting;
    }

    public static class Builder<V extends EntityVehicle> {
        final V v;
        SoundEvent acc;
        SoundEvent brk;
        SoundEvent rls;
        SoundEvent str;
        SoundEvent honk;
        SoundEvent starting;

        Builder(V v) {
            this.v = v;
        }

        public Builder<V> acc(SoundEvent event) {
            this.acc = event;
            return this;
        }

        public Builder<V> brk(SoundEvent event) {
            this.brk = event;
            return this;
        }

        public Builder<V> rls(SoundEvent event) {
            this.rls = event;
            return this;
        }

        public Builder<V> str(SoundEvent event) {
            this.str = event;
            return this;
        }

        public Builder<V> honk(SoundEvent event) {
            this.honk = event;
            return this;
        }

        public Builder<V> starting(SoundEvent event) {
            this.starting = event;
            return this;
        }

        public VehicleSoundPack build() {
            Objects.requireNonNull(this.acc, "Undefined Accelerate sound");
            Objects.requireNonNull(this.brk, "Undefined Brake sound");
            Objects.requireNonNull(this.rls, "Undefined Release sound");
            Objects.requireNonNull(this.str, "Undefined Start sound");
            Objects.requireNonNull(this.honk, "Undefined Honk sound");
            Objects.requireNonNull(this.starting, "Undefined Starting sound");
            return new VehicleSoundPack(this);
        }

        public static <V extends EntityVehicle> Builder<V> create(V v) {
            return new Builder<V>(Objects.requireNonNull(v, "Vehicle cannot be null!"));
        }
    }
}

