/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.gui;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.blocks.fuel.TileEntityFuelMaker;
import dev.toma.vehiclemod.common.container.ContainerFuelMaker;
import dev.toma.vehiclemod.common.fluids.FluidEntry;
import dev.toma.vehiclemod.network.VMNetworkManager;
import dev.toma.vehiclemod.network.packets.SPacketFuelMakerAction;
import dev.toma.vehiclemod.util.DevUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiFuelMaker
extends GuiContainer {
    static final DecimalFormat FORMAT = new DecimalFormat("###.##");
    public static final ResourceLocation TEXTURE;
    private final TileEntityFuelMaker tileEntityFuelMaker;

    public GuiFuelMaker(InventoryPlayer player, TileEntityFuelMaker tileEntityFuelMaker) {
        super((Container)new ContainerFuelMaker(player, tileEntityFuelMaker));
        this.tileEntityFuelMaker = tileEntityFuelMaker;
        this.field_146999_f = 176;
        this.field_147000_g = 230;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new ActionButton(0, this.field_147003_i + 5, this.field_147009_r + 97, 8, 8, "Dump fluid"));
        this.func_189646_b(new ActionButton(1, this.field_147003_i + 145, this.field_147009_r + 5, 8, 8, "Transfer"));
        this.func_189646_b(new ActionButton(2, this.field_147003_i + 37, this.field_147009_r + 106, 8, 8, "To bucket"));
        this.func_189646_b(new ActionButton(3, this.field_147003_i + 145, this.field_147009_r + 106, 8, 8, "To bucket"));
    }

    protected void func_146284_a(GuiButton button) {
        VMNetworkManager.instance().sendToServer((IMessage)new SPacketFuelMakerAction(this.tileEntityFuelMaker.func_174877_v(), button.field_146127_k, GuiFuelMaker.func_146272_n()));
        try {
            this.tileEntityFuelMaker.runAction(button.field_146127_k, GuiFuelMaker.func_146272_n());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179140_f();
        FluidEntry input = this.tileEntityFuelMaker.getInput();
        this.drawFluid(25, input);
        this.drawFuelBarIndicator(25);
        this.drawFluid(133, this.tileEntityFuelMaker.getOutput());
        this.drawFuelBarIndicator(133);
        if (this.tileEntityFuelMaker.isWorking()) {
            float prg = (float)this.tileEntityFuelMaker.getProcessTimer() / (float)input.getType().getProcessResult().getProcessTime();
            int diff = 32;
            double aus = 0.6875;
            double aue = (double)(176.0f + (float)diff * prg) / 256.0;
            double avs = 0.28515625;
            double ave = 0.328125;
            this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            builder.func_181662_b(72.0, 61.0, 0.0).func_187315_a(aus, ave).func_181675_d();
            builder.func_181662_b((double)(72.0f + (float)diff * prg), 61.0, 0.0).func_187315_a(aue, ave).func_181675_d();
            builder.func_181662_b((double)(72.0f + (float)diff * prg), 50.0, 0.0).func_187315_a(aue, avs).func_181675_d();
            builder.func_181662_b(72.0, 50.0, 0.0).func_187315_a(aus, avs).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179145_e();
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        if (x >= 25 && x <= 42 && y >= 28 && y <= 100) {
            this.drawFluidInfo(this.tileEntityFuelMaker.getInput(), x, y);
        } else if (x >= 133 && x <= 150 && y >= 28 && y <= 100) {
            this.drawFluidInfo(this.tileEntityFuelMaker.getOutput(), x, y);
        } else {
            this.func_191948_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof ActionButton) || !((ActionButton)button).isHovered()) continue;
            String text = ((ActionButton)button).text;
            this.func_146279_a(text, mouseX, mouseY);
            break;
        }
        this.func_191948_b(mouseX, mouseY);
    }

    private void drawFluidInfo(FluidEntry entry, int x, int y) {
        if (entry.isEmpty()) {
            return;
        }
        String text = String.format("%s [%sL / %sL]", entry.getType().getDisplayName().func_150254_d(), FORMAT.format((float)entry.getAmount() / 1000.0f), FORMAT.format((float)entry.getLimit() / 1000.0f));
        this.func_146279_a(text, x, y);
    }

    private void drawFluid(int x, FluidEntry entry) {
        if (entry.isEmpty() || entry.getAmount() == 0) {
            return;
        }
        float f = (float)entry.getAmount() / 250000.0f;
        double u1 = 0.7578125;
        double u2 = 0.828125;
        double v2 = 0.28515625;
        double v1 = v2 * (double)(1.0f - f);
        int color = entry.getType().getFluidColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        builder.func_181662_b((double)x, 101.0, 0.0).func_187315_a(u1, v2).func_181666_a(r, g, b, 1.0f).func_181675_d();
        builder.func_181662_b((double)(x + 18), 101.0, 0.0).func_187315_a(u2, v2).func_181666_a(r, g, b, 1.0f).func_181675_d();
        builder.func_181662_b((double)(x + 18), (double)(101.0f - 73.0f * f), 0.0).func_187315_a(u2, v1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        builder.func_181662_b((double)x, (double)(101.0f - 73.0f * f), 0.0).func_187315_a(u1, v1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    private void drawFuelBarIndicator(int x) {
        double startU = 0.6875;
        double endU = 0.7578125;
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b((double)x, 101.0, 0.0).func_187315_a(startU, 0.28515625).func_181675_d();
        builder.func_181662_b((double)(x + 18), 101.0, 0.0).func_187315_a(endU, 0.28515625).func_181675_d();
        builder.func_181662_b((double)(x + 18), 28.0, 0.0).func_187315_a(endU, 0.0).func_181675_d();
        builder.func_181662_b((double)x, 28.0, 0.0).func_187315_a(startU, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        FORMAT.setDecimalFormatSymbols(symbols);
        TEXTURE = new ResourceLocation("vehiclemod", "textures/gui/fuel_maker.png");
    }

    static class ActionButton
    extends GuiButton {
        static final ResourceLocation TXT = VehicleMod.getResource("textures/gui/mini_buttons.png");
        final String text;

        ActionButton(int i, int x, int y, int width, int heigth, String text) {
            super(i, x, y, width, heigth, "");
            this.text = text;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseX <= this.field_146128_h + this.field_146120_f && mouseY >= this.field_146129_i && mouseY <= this.field_146129_i + this.field_146121_g;
            double v1 = this.field_146123_n ? 0.5 : 0.0;
            double v2 = this.field_146123_n ? 1.0 : 0.5;
            DevUtil.drawImage2D(mc, TXT, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 0.0, v1, 1.0, v2);
        }

        boolean isHovered() {
            return this.field_146123_n;
        }
    }
}

