/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.gui;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.blocks.BlockPetrolPump;
import dev.toma.vehiclemod.common.container.ContainerPetrolPump;
import dev.toma.vehiclemod.common.tileentity.TileEntityPetrolPump;
import dev.toma.vehiclemod.network.VMNetworkManager;
import dev.toma.vehiclemod.network.packets.SPacketUpdateTileEntity;
import java.io.IOException;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiPetrolPump
extends GuiContainer {
    private static final ResourceLocation TEXTURE = VehicleMod.getResource("textures/gui/petrol_pump.png");
    private final TileEntityPetrolPump petrolPump;

    public GuiPetrolPump(InventoryPlayer inv, TileEntityPetrolPump petrolPump) {
        super((Container)new ContainerPetrolPump(inv, petrolPump));
        this.petrolPump = petrolPump;
        this.field_146999_f = 176;
        this.field_147000_g = 169;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new GuiButton(0, this.field_147003_i + this.field_146999_f - 37, this.field_147009_r + 7, 30, 20, "Find"));
        this.func_189646_b(new GuiButton(1, this.field_147003_i + this.field_146999_f - 37, this.field_147009_r + 32, 30, 20, "Start"));
        this.func_189646_b(new GuiButton(2, this.field_147003_i + this.field_146999_f - 37, this.field_147009_r + 57, 30, 20, "Stop"));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                this.petrolPump.pair((EnumFacing)this.field_146297_k.field_71441_e.func_180495_p(this.petrolPump.func_174877_v()).func_177229_b((IProperty)BlockPetrolPump.FACING));
                this.sync();
                break;
            }
            case 1: {
                this.petrolPump.transfer = true;
                this.sync();
                break;
            }
            case 2: {
                this.petrolPump.transfer = false;
                this.sync();
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawFuelBar(11, this.petrolPump.storedAmount / TileEntityPetrolPump.CAPACITY);
        if (this.petrolPump.pairedVehicle != null) {
            this.drawFuelBar(50, this.petrolPump.pairedVehicle.fuel / (float)this.petrolPump.pairedVehicle.getActualStats().fuelCapacity);
        }
        this.field_146297_k.field_71466_p.func_175063_a("Stored: " + (int)this.petrolPump.storedAmount + "L", (float)(this.field_147003_i + 33), (float)(this.field_147009_r + 25), -1);
        this.field_146297_k.field_71466_p.func_175063_a("Vehicle: " + (this.petrolPump.pairedVehicle != null ? (int)this.petrolPump.pairedVehicle.fuel + "L" : "No vehicle"), (float)(this.field_147003_i + 33), (float)(this.field_147009_r + 63), -1);
    }

    private void sync() {
        VMNetworkManager.instance().sendToServer((IMessage)new SPacketUpdateTileEntity(this.petrolPump.func_174877_v(), this.petrolPump.func_189515_b(new NBTTagCompound())));
    }

    private void drawFuelBar(int y, float amount) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_181662_b((double)(this.field_147003_i + 32), (double)(this.field_147009_r + y + 10), 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_181662_b((double)(this.field_147003_i + 133), (double)(this.field_147009_r + y + 10), 0.0).func_181666_a(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_181662_b((double)(this.field_147003_i + 133), (double)(this.field_147009_r + y), 0.0).func_181666_a(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_181662_b((double)(this.field_147003_i + 32), (double)(this.field_147009_r + y), 0.0).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_181662_b((double)((float)(this.field_147003_i + 32) + 101.0f * amount - 1.0f), (double)(this.field_147009_r + y + 10), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_181662_b((double)((float)(this.field_147003_i + 32) + 101.0f * amount + 1.0f), (double)(this.field_147009_r + y + 10), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_181662_b((double)((float)(this.field_147003_i + 32) + 101.0f * amount + 1.0f), (double)(this.field_147009_r + y), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_181662_b((double)((float)(this.field_147003_i + 32) + 101.0f * amount - 1.0f), (double)(this.field_147009_r + y), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
    }
}

