/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.gui.tunning;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.client.gui.tunning.EnumTunningType;
import dev.toma.vehiclemod.client.gui.tunning.GuiTunning;
import dev.toma.vehiclemod.common.container.ContainerNeons;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.inventory.InventoryNeons;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class GuiNeons
extends GuiTunning<InventoryNeons, ContainerNeons> {
    private static final ResourceLocation TEXTURE = VehicleMod.getResource("textures/gui/neons_tab.png");
    private int scale = 15;
    private int prevDragMouseX;
    private int prevDragMouseY;
    private float yaw = 45.0f;
    private float pitch = -45.0f;

    public GuiNeons(InventoryPlayer playerInventory, InventoryNeons neons) {
        super(playerInventory, neons, ContainerNeons::new, EnumTunningType.NEONS);
        this.field_147000_g = 196;
    }

    @Override
    public boolean isButtonEnabled(EnumTunningType tunningType) {
        return tunningType != EnumTunningType.NEONS || !((InventoryNeons)((Object)((ContainerNeons)this.container).getIInventory())).getVehicle().getVehiclePositions().areNeonsDisabled();
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        EntityVehicle vehicle = ((InventoryNeons)((Object)((ContainerNeons)this.container).getIInventory())).getVehicle();
        if (vehicle != null) {
            this.drawEntityOnScreen(vehicle);
        }
    }

    public void func_146274_d() throws IOException {
        int i = Integer.signum(Mouse.getEventDWheel());
        if (i != 0) {
            this.scale = MathHelper.func_76125_a((int)(this.scale + i), (int)10, (int)30);
        }
        super.func_146274_d();
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (clickedMouseButton == 0 && mouseX >= this.field_147003_i + 7 && mouseX <= this.field_147003_i + 168 && mouseY >= this.field_147009_r + 7 && mouseY <= this.field_147009_r + 85) {
            int xDelta = this.prevDragMouseX - mouseX;
            int yDelta = this.prevDragMouseY - mouseY;
            if (Math.abs(xDelta) < 30) {
                this.modifyYaw(xDelta);
            }
            if (Math.abs(yDelta) < 30) {
                this.modifyPitch(yDelta);
            }
            this.prevDragMouseX = mouseX;
            this.prevDragMouseY = mouseY;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    void modifyYaw(int delta) {
        float newYaw;
        for (newYaw = this.yaw + (float)delta; newYaw > 180.0f; newYaw -= 360.0f) {
        }
        while (newYaw < -180.0f) {
            newYaw += 360.0f;
        }
        this.yaw = newYaw;
    }

    void modifyPitch(int delta) {
        this.pitch = MathHelper.func_76131_a((float)(this.pitch + (float)delta), (float)-60.0f, (float)60.0f);
    }

    void drawEntityOnScreen(Entity ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)88.0f, (float)60.0f, (float)60.0f);
        GlStateManager.func_179152_a((float)(-this.scale), (float)this.scale, (float)this.scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(this.pitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a(ent, 0.0, 0.0, 0.0, this.yaw, 1.0f, false);
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }
}

