/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.gui.tunning;

import dev.toma.vehiclemod.client.gui.tunning.EnumTunningType;
import dev.toma.vehiclemod.common.container.ModContainer;
import dev.toma.vehiclemod.network.VMNetworkManager;
import dev.toma.vehiclemod.network.packets.SPacketOpenVehicleComponentGUI;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class GuiTunning<I extends IInventory, C extends ModContainer<I>>
extends GuiContainer {
    protected final C container;
    final EnumTunningType tunningType;

    public GuiTunning(InventoryPlayer player, I inventory, BiFunction<InventoryPlayer, I, C> containerFactory, EnumTunningType tunningType) {
        super((Container)containerFactory.apply(player, inventory));
        this.container = (ModContainer)this.field_147002_h;
        this.tunningType = tunningType;
    }

    public abstract ResourceLocation getTexture();

    public void func_73866_w_() {
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = 10 + (this.field_146295_m - this.field_147000_g) / 2;
        int i = 0;
        for (EnumTunningType type : EnumTunningType.values()) {
            TabButton button = (TabButton)this.func_189646_b(new TabButton(this, i, this.field_147003_i + 5 + i * 32, this.field_147009_r - 27, 30, 27, type));
            button.field_146125_m = this.isButtonEnabled(type);
            button.field_146124_l = button.field_146125_m && this.tunningType != button.type;
            ++i;
        }
    }

    public boolean isButtonEnabled(EnumTunningType tunningType) {
        return true;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof TabButton) {
            TabButton tabButton = (TabButton)button;
            VMNetworkManager.instance().sendToServer((IMessage)new SPacketOpenVehicleComponentGUI(tabButton.type.getGuiID()));
        }
    }

    static class TabButton
    extends GuiButton {
        final GuiTunning<?, ?> parent;
        final EnumTunningType type;

        public TabButton(GuiTunning<?, ?> parent, int id, int x, int y, int w, int h, EnumTunningType type) {
            super(id, x, y, w, h, "");
            this.type = type;
            this.parent = parent;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            mc.func_110434_K().func_110577_a(this.parent.getTexture());
            if (this.field_146125_m) {
                if (this.field_146124_l) {
                    TabButton.drawTexture(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 0.0, 0.10546875);
                    if (this.field_146123_n) {
                        FontRenderer renderer = mc.field_71466_p;
                        int textWidth = renderer.func_78256_a(this.type.getDisplayName());
                        renderer.func_175065_a(this.type.getDisplayName(), (float)this.field_146128_h + (float)(this.field_146120_f - textWidth) / 2.0f, (float)(this.field_146129_i - 8), 0xFFFFFF, false);
                    }
                } else {
                    TabButton.drawTexture(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g + 3, 0.10546875, 0.22265625);
                }
            } else {
                TabButton.drawTexture(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 0.22265625, 0.328125);
            }
            mc.func_175599_af().func_175042_a(this.type.getDisplayIcon(), this.field_146128_h + 7, this.field_146129_i + 7);
        }

        static void drawTexture(int x, int y, int w, int h, double v1, double v2) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            builder.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(0.87890625, v2).func_181675_d();
            builder.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(1.0, v2).func_181675_d();
            builder.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(1.0, v1).func_181675_d();
            builder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.87890625, v1).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

