/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.gui.tunning;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.client.gui.tunning.EnumTunningType;
import dev.toma.vehiclemod.client.gui.tunning.GuiTunning;
import dev.toma.vehiclemod.common.container.ContainerVehicleComponents;
import dev.toma.vehiclemod.common.entity.vehicle.VehicleUpgrades;
import dev.toma.vehiclemod.common.inventory.InventoryComponents;
import dev.toma.vehiclemod.common.items.ItemVehicleUpgrade;
import dev.toma.vehiclemod.config.VehicleStats;
import dev.toma.vehiclemod.util.DevUtil;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiVehicleComponents
extends GuiTunning<InventoryComponents, ContainerVehicleComponents> {
    private static final ResourceLocation TEXTURE = VehicleMod.getResource("textures/gui/tunning_tab.png");

    public GuiVehicleComponents(InventoryPlayer player, InventoryComponents components) {
        super(player, components, ContainerVehicleComponents::new, EnumTunningType.STATS);
        this.field_146999_f = 205;
        this.field_147000_g = 176;
    }

    @Override
    public boolean isButtonEnabled(EnumTunningType tunningType) {
        return tunningType != EnumTunningType.NEONS || !((InventoryComponents)((Object)((ContainerVehicleComponents)this.container).getIInventory())).getVehicle().getVehiclePositions().areNeonsDisabled();
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        InventoryComponents components = (InventoryComponents)((Object)((ContainerVehicleComponents)this.field_147002_h).getIInventory());
        VehicleUpgrades upgrades = components.getUpgrades();
        if (components.getVehicle() != null) {
            VehicleStats stats = components.getVehicle().getActualStats();
            float speedStat = GuiVehicleComponents.fixValue((stats.maxSpeed - VehicleStats.topSpeedMin) / (VehicleStats.topSpeedMax - VehicleStats.topSpeedMin));
            float accelerationStat = GuiVehicleComponents.fixValue((stats.acceleration - VehicleStats.accelerationMin) / (VehicleStats.accelerationMax - VehicleStats.accelerationMin));
            float handlingStat = GuiVehicleComponents.fixValue((stats.turnSpeed - VehicleStats.handlingMin) / (VehicleStats.handlingMax - VehicleStats.handlingMin));
            float brakingStat = GuiVehicleComponents.fixValue((stats.brakeSpeed - VehicleStats.brakingMin) / (VehicleStats.brakingMax - VehicleStats.brakingMin));
            this.field_146289_q.func_78276_b("SPD", 8, 54, 43520);
            this.field_146289_q.func_78276_b("ACC", 8, 63, 0xAA0000);
            this.field_146289_q.func_78276_b("HDL", 8, 72, 170);
            this.field_146289_q.func_78276_b("BRK", 8, 81, 0xAAAA00);
            DevUtil.drawColor(27, 55, (int)(27.0f + 142.0f * speedStat), 60, 0.0f, 1.0f, 0.0f, 1.0f);
            DevUtil.drawColor(27, 64, (int)(27.0f + 142.0f * accelerationStat), 69, 1.0f, 0.0f, 0.0f, 1.0f);
            DevUtil.drawColor(27, 73, (int)(27.0f + 142.0f * handlingStat), 78, 0.0f, 0.0f, 1.0f, 1.0f);
            DevUtil.drawColor(27, 82, (int)(27.0f + 142.0f * brakingStat), 87, 1.0f, 1.0f, 0.0f, 1.0f);
        }
        Map<ItemVehicleUpgrade.Type, Integer> map = upgrades.getUpgradeMap();
        int j = 0;
        for (Map.Entry<ItemVehicleUpgrade.Type, Integer> entry : map.entrySet()) {
            String text = String.format("[%d]", entry.getValue());
            this.field_146289_q.func_78276_b(text, 8 + j * 18 + (18 - this.field_146289_q.func_78256_a(text)) / 2, 28, ItemVehicleUpgrade.Type.getColor(entry.getValue()).func_193350_e());
            ++j;
        }
    }

    static float fixValue(float in) {
        return in > 0.999f ? 1.0f : in;
    }
}

