/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.lights;

import dev.toma.vehiclemod.client.lights.LightEntry;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import net.minecraft.client.model.ModelRenderer;

public class BasicLightEntry<V extends EntityVehicle>
implements LightEntry<V> {
    private int x;
    private int y;
    private final ModelRenderer[] renderers;

    protected BasicLightEntry(float lightIntensity, ModelRenderer ... renderers) {
        this.recalculateForIntensity(lightIntensity);
        this.renderers = renderers;
    }

    public void recalculateForIntensity(float intensity) {
        int value = (int)(15.0f * intensity);
        int totalLight = 0xF00000 | value << 4;
        this.setLightmapX(totalLight % 65536);
        this.setLightmapY(totalLight / 65536);
    }

    @Override
    public int getLightmapX() {
        return this.x;
    }

    @Override
    public int getLightmapY() {
        return this.y;
    }

    @Override
    public void setLightmapX(int x) {
        this.x = x;
    }

    @Override
    public void setLightmapY(int y) {
        this.y = y;
    }

    @Override
    public ModelRenderer[] getModels() {
        return this.renderers;
    }

    @Override
    public boolean shouldApplyLight(V vehicle) {
        return true;
    }
}

